% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_msready_by_mass_batch}
\alias{get_msready_by_mass_batch}
\title{Get ms ready by mass batch search}
\usage{
get_msready_by_mass_batch(
  start_list = NULL,
  end_list = NULL,
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{start_list}{A numeric list of starting values for mass range}

\item{end_list}{A numeric list of ending values for mass range}

\item{API_key}{The user-specific API key}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of character lists with DTXSIDs with msready masses
falling within the given ranges.
}
\description{
Get ms ready by mass batch search
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull msready chemicals by mass ranges
msready_data <- get_msready_by_mass_batch(start_list = c(200.9, 200.95),
                                          end_list = c(200.95, 201.00))
\dontshow{\}) # examplesIf}
}
