# A simulated data set
data('sim.cureph.data')
# Or you may generate another one
sim.cureph.data = cureph.simgen()

# Check out the true coefficients and baseline survival
attributes(sim.cureph.data)

# Fit logistic-CoxPH cure-rate model
fit=cureph(Surv.cure(time,time2,event,origin=0,end=20)~Z1+Z2+Z3,data=sim.cureph.data)

# Check out the summary
summary(fit)

# Baseline cummulative hazard
basehaz.cureph(fit)
