% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-Draw.R
\name{draw_fn}
\alias{draw_fn}
\title{Draw a Function}
\usage{
draw_fn(x1, x2, fn, n = 50, text = "x", ...)
}
\arguments{
\item{x1}{starting column value of the path}

\item{x2}{ending column value of the path}

\item{fn}{function returning row value for a column input}

\item{n}{number of points along curve to calculate}

\item{text}{character value drawn at coordinate}

\item{...}{parameters that are passed to \code{style()}, including the foreground color \code{fg}, background color \code{bg}, and attribute \code{attr}}
}
\value{
\code{NULL}
}
\description{
Calculate the path within a grid of an user-supplied function and print to screen.
}
\examples{
draw_fn(x1=1, x2=10,
  function(x){sqrt(x)}
)

}
\seealso{
Other drawing functions: 
\code{\link{box_at}()},
\code{\link{draw_arc}()},
\code{\link{draw_bezier}()},
\code{\link{draw_circle}()},
\code{\link{draw_ellipse}()},
\code{\link{draw_lerp}()},
\code{\link{draw_path}()},
\code{\link{draw_ray}()},
\code{\link{draw_rect}()},
\code{\link{draw_shape}()},
\code{\link{fill_circle}()},
\code{\link{fill_ellipse}()},
\code{\link{fill_rect}()},
\code{\link{fill_shape}()},
\code{\link{grid_at}()},
\code{\link{grid_mat}()},
\code{\link{hline_at}()},
\code{\link{hline}()},
\code{\link{vline_at}()},
\code{\link{vline}()}
}
\concept{drawing functions}
