% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-Draw.R
\name{draw_ray}
\alias{draw_ray}
\title{Draw a Ray}
\usage{
draw_ray(start, end, lim = c(64, 128), n = 200, text = "x", ...)
}
\arguments{
\item{start}{start \code{(row, col)} coordinate of the ray}

\item{end}{either an ending coording, an angle in radians, or a character direction (u, d, l, r, ul, ur, dl, dr)}

\item{lim}{bounding box dimensions used to calculate ray}

\item{n}{number of points along curve to calculate}

\item{text}{character value drawn at coordinate}

\item{...}{parameters that are passed to \code{style()}, including the foreground color \code{fg}, background color \code{bg}, and attribute \code{attr}}
}
\value{
\code{NULL}
}
\description{
Calculate the path of a ray extending and print to screen.
}
\examples{
draw_ray(start=c(10,10), end=pi/6)
draw_ray(start=c(10,10), end=pi/6, lim=c(15,15))
draw_ray(start=c(10,10), end=c(4,2))

}
\seealso{
Other drawing functions: 
\code{\link{box_at}()},
\code{\link{draw_arc}()},
\code{\link{draw_bezier}()},
\code{\link{draw_circle}()},
\code{\link{draw_ellipse}()},
\code{\link{draw_fn}()},
\code{\link{draw_lerp}()},
\code{\link{draw_path}()},
\code{\link{draw_rect}()},
\code{\link{draw_shape}()},
\code{\link{fill_circle}()},
\code{\link{fill_ellipse}()},
\code{\link{fill_rect}()},
\code{\link{fill_shape}()},
\code{\link{grid_at}()},
\code{\link{grid_mat}()},
\code{\link{hline_at}()},
\code{\link{hline}()},
\code{\link{vline_at}()},
\code{\link{vline}()}
}
\concept{drawing functions}
