% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-Draw.R
\name{grid_mat}
\alias{grid_mat}
\title{Create a Character Grid Matrix}
\usage{
grid_mat(
  dim,
  step = c(2, 2),
  text = c(".", ".", "+", "|", "|", "-", "-", rep("+", 8)),
  border = TRUE
)
}
\arguments{
\item{dim}{\code{(row, column)} vector for size of grid.}

\item{step}{numeric vector describing grid step across \code{(rows, columns)}}

\item{text}{character vector of values for the grid, in order: horizontal grid line, vertical grid line, grid intersection, left border, right border, top border, bottom border, corners (upper-left, upper-right, lower-left, lower-right), ticks (right, bottom, left, top)}

\item{border}{logical value for whether a border should be included.}
}
\value{
\code{row}x\code{col} matrix
}
\description{
Constructs a grid with provided dimensions \code{(row, col)}, character values for gridlines, and a step parameter noting the number of rows and columns between each gridline.
}
\examples{
grid_mat(dim=c(11,13), step=c(2,4), border=TRUE)

}
\seealso{
Other drawing functions: 
\code{\link{box_at}()},
\code{\link{draw_arc}()},
\code{\link{draw_bezier}()},
\code{\link{draw_circle}()},
\code{\link{draw_ellipse}()},
\code{\link{draw_fn}()},
\code{\link{draw_lerp}()},
\code{\link{draw_path}()},
\code{\link{draw_ray}()},
\code{\link{draw_rect}()},
\code{\link{draw_shape}()},
\code{\link{fill_circle}()},
\code{\link{fill_ellipse}()},
\code{\link{fill_rect}()},
\code{\link{fill_shape}()},
\code{\link{grid_at}()},
\code{\link{hline_at}()},
\code{\link{hline}()},
\code{\link{vline_at}()},
\code{\link{vline}()}
}
\concept{drawing functions}
