% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npcurve.R
\name{npcurve}
\alias{npcurve}
\title{Reserve demand non-parametric curve}
\usage{
npcurve(x, y, type = c("rforest", "spline"), dummy = NULL, q = NULL, ...)
}
\arguments{
\item{x}{A matrix of explanatory variables. Excess reserve must be the first input.Additional regressor follow (optional).}

\item{y}{A vector of normalised interest rates.}

\item{type}{The type of the reserve demand curve. This can be any of \code{rforecast} for random forecast or \code{spline} for spline regression.}

\item{dummy}{Optional input to signify a regime change (vertical shifts in the curve). Must be a vector of equal length to the rows of \code{x}. If not needed use \code{NULL}.}

\item{q}{Target interval. This is a scalar below 1, for example 0.9 is the 90\% interval. If \code{NULL} then no quantiles are estimated.}

\item{...}{Additional arguments (unused).}
}
\value{
Returns a model of class \code{npcurvir}. This includes
\itemize{
 \item \code{type} the type of the curve.
 \item \code{fit} the non-parametric model for the mean.
 \item \code{fitQ} The non-parametric model for the quantiles.
 \item \code{data} a list including the \code{y}, \code{x}, and \code{dummy} used for the fitting of the curve.
 \item \code{q} the interval used in the fitting of the curve.
}
}
\description{
Fits a non-parametric reserve demand curve between excess reserves and normalised rates
}
\examples{
# Use ECB example data
rate <- ecb$rate
x <- ecb$x[,1,drop=FALSE]
npcurve(x,rate)

}
\references{
Chen, Z., Kourentzes, N., & Veyrune, R. (2023). \href{https://www.imf.org/en/Publications/WP/Issues/2023/09/01/Modeling-the-Reserve-Demand-to-Facilitate-Central-Bank-Operations-538754}{Modeling the Reserve Demand to Facilitate Central Bank Operations.} IMF Working Papers, 2023(179).
}
\seealso{
\code{\link{predict.npcurvir}}, and \code{\link{plot.npcurvir}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
