% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_value_plot.R
\name{cp_value_plot}
\alias{cp_value_plot}
\title{Plot AIC and LRT-statistics values from \code{cpobj} object}
\usage{
cp_value_plot(
  cpobj,
  plotvalues = "AIC",
  dp.plot = 2,
  show_limit = TRUE,
  plottype2cp = "contour"
)
}
\arguments{
\item{cpobj}{list, contains a vector of AIC values (AIC_values) and
Likelihood ratio test statistic values (LRT_values) of the estimating
procedure}

\item{plotvalues}{character, either \code{AIC} or \code{LRT}. Either the AIC or
LRT values are displayed. Default is \code{AIC}.}

\item{dp.plot}{numeric, digits for the AIC values and LRT values.
Default is \code{2}.}

\item{show_limit}{logical, if \code{TRUE} the minimum AIC value is shown in the
plot if \code{plotvalues = "AIC"}, and the maximum LRT value is shown if
\code{plotvalues = "LRT"}}

\item{plottype2cp}{character, either \code{contour} or \code{index}. Default is
\code{contour}. This option is available only when searching for two cutpoints.
Index plots and contour plots can be selected. Index plots display all AIC
or LRT values from the estimation process as a scatter plot. Contour plots
are shown in the RStudio viewer and illustrate the two potential cutpoints
along with the corresponding AIC or LRT values. Index plots that do not
show extreme values suggest that there may not be any actual cutpoints in
the data. Contour plots provide an opportunity to explore whether there
might be other potential cutpoints with similar AIC or LRT values. The
smaller the \code{bandwidth} (minimum group size per group), the more precise
and meaningful the contour plots can be interpreted.}
}
\value{
Plots the AIC- or LRT-values, derived from the estimation procedure.
}
\description{
Create a plot of AIC or Likelihood ratio test statistic values
for the estimation procedure. If there are two cutpoints, a Contour-plot
and an Index-plot can be generated.
}
\examples{
# Example 1
# Plot AIC-values and potential cutpoints of the estimation process

# Create AIC values:
AIC_values <- c(1950:1910, 1910:1920, 1920:1880, 1880:1920)
AIC_values <- round(AIC_values + rnorm(length(AIC_values),
                   mean = 0, sd = 5), digits = 2)

# Create a cutpoint variable:
cpvariable_values <- matrix(NA, nrow = length(AIC_values), ncol = 2)
cpvariable_values[ ,1] <- c(1:length(AIC_values))

# Create a cutpoint object (cpobj):
cpobj <- list(AIC_values        = AIC_values,
              nb_of_cp          = 1,
              cpvariable_values = cpvariable_values,
              cpvarname         = "Cutpoint variable"
              )

cp_value_plot(cpobj, plotvalues = "AIC", dp.plot = 2, show_limit = TRUE)

\donttest{
# Example 2
# Splines plot based on data1
# The data set data1 is included in this package
cpobj <- cp_est(
  cpvarname    = "biomarker",
  covariates   = c("covariate_1", "covariate_2"),
  data         = data1,
  nb_of_cp     = 2,
  plot_splines = TRUE,
)
# Example 3
# Contour plot based on data1
# The data set data1 is included in this package
cpobj <- cp_est(
   cpvarname    = "biomarker",
   covariates   = c("covariate_1", "covariate_2"),
   data         = data1,
   nb_of_cp     = 2,
   plot_splines = FALSE,
)
cp_value_plot(cpobj, plotvalues = "AIC", plottype2cp = "contour")
}
}
\seealso{
\code{\link[=cp_est]{cp_est()}} for main function of the package, \code{\link[=cp_splines_plot]{cp_splines_plot()}}
for penalized spline plots
}
