% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_init.R
\name{set_init}
\alias{set_init}
\alias{set_init,EffectScenario-method}
\alias{set_init,ScenarioSequence-method}
\alias{set_init,vector-method}
\title{Set initial state}
\usage{
set_init(x, init)

\S4method{set_init}{EffectScenario}(x, init)

\S4method{set_init}{ScenarioSequence}(x, init)

\S4method{set_init}{vector}(x, init)
}
\arguments{
\item{x}{vector of \code{EffectScenario} objects}

\item{init}{named numeric vector}
}
\value{
modified \code{EffectScenario} objects
}
\description{
The \emph{initial state} represents the starting values of a scenario's state
variables when starting a simulation. A scenario's default initial state
may be insufficient to get sensible results.
}
\details{
In theory, a scenarios's state variables can be renamed by modifying the names
of the initial state vector. However, this is strongly
discouraged as this will affect other routines such as \code{\link[=effect]{effect()}} and \code{\link[=epx]{epx()}}
and may render results useless.
}
\examples{
# Set initial biomass to 1.0
metsulfuron \%>\% set_init(c(BM=1.0)) \%>\% simulate()
}
