% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_memoise.R
\name{cvd_clear_cache}
\alias{cvd_clear_cache}
\title{Clear package cache}
\usage{
cvd_clear_cache()
}
\value{
Invisibly returns TRUE on success
}
\description{
Remove all entries from the memoise cache used by cvdprevent.
}
\details{
This function forces the package cache to be emptied. It is safe to call from interactive sessions, non-interactive checks and tests. Clearing the cache does not change any package options or remove the cache directory; it only removes the stored key/value entries so subsequent calls will re-query the API.

Use this when you want to:
\itemize{
\item force fresh API requests or recomputation during development
\item clear stale or corrupted cache contents before running checks
\item free disc space used by the cache
}
}
\examples{
\dontrun{
# Clear cache
cvd_clear_cache()
}

}
