% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{calc_quantiles_obs}
\alias{calc_quantiles_obs}
\alias{calc_quantiles_pred}
\title{Calculate Quantiles}
\usage{
calc_quantiles_obs(rts_u, rts_l, one_cond, probs)

calc_quantiles_pred(
  pdf_u,
  pdf_l,
  t_vec,
  one_cond,
  probs,
  dt,
  skip_if_contr_low = NULL
)
}
\arguments{
\item{rts_u, rts_l}{vectors of RTs for the upper and lower boundary}

\item{one_cond}{character label}

\item{probs}{numeric vector with values between 0 and 1 for the probability
levels}

\item{pdf_u, pdf_l}{density values for the upper and lower boundary}

\item{t_vec}{the time space (required for the pdfs)}

\item{dt}{the step size corresponding to the time space}

\item{skip_if_contr_low}{numeric. If the contribution of the upper
or lower PDF to the overall PDF is too low, return NAs for
this PDF (see also \code{\link[=drift_dm_skip_if_contr_low]{drift_dm_skip_if_contr_low()}}).}
}
\value{
a data.frame with the "Cond" label, the "Prob"s and "Quant_U" and
"Quant_L" for the quantiles
}
\description{
Backend functions to calculate quantiles for RT vectors or pdfs
}
\details{
for RTs:
straightforward via \link[stats:quantile]{stats::quantile}.

for Densities: Calculate CDF (for each pdf separately here), and then map
the desired probability level via the CDF (y-axis) to the time space (x-axis)
}
\keyword{internal}
