% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_bayes_estimate.R
\name{dtnorm}
\alias{dtnorm}
\alias{rtnorm}
\title{Truncated Normal Density Function}
\usage{
dtnorm(x, mean = 0, sd = 1, lower = -Inf, upper = Inf, log = FALSE)

rtnorm(n, mean = 0, sd = 1, lower = -Inf, upper = Inf)
}
\arguments{
\item{x}{A numeric vector or matrix of values where the density should be
evaluated.}

\item{mean}{Mean of the normal distribution. Can be a scalar or vector
(recycled if necessary).}

\item{sd}{Standard deviation of the normal distribution. Can be a scalar or
vector (recycled if necessary).}

\item{lower}{Lower truncation bound. Can be a scalar or vector
(recycled if necessary). Default is \code{-Inf}.}

\item{upper}{Upper truncation bound. Can be a scalar or vector
(recycled if necessary). Default is \code{Inf}.}

\item{log}{Logical; if \code{TRUE}, probabilities \code{p} are given as \code{log(p)}.
Default is \code{FALSE}.}
}
\value{
A numeric vector or matrix of the same shape as \code{x}, containing the
(possibly log) densities.
}
\description{
Computes the probability density function for the truncated normal
distribution. This version supports both vector and matrix input for \code{x}.
}
\details{
The function evaluates the normal density at \code{x} and scales it to reflect
truncation to the interval (\code{lower}, \code{upper}). Values outside the truncation
bounds are assigned a density of 0 (or \code{-Inf} on the log scale).
Internally, \link[stats:Normal]{stats::dnorm} and \link[stats:Normal]{stats::pnorm} are used.

If \code{x} is a matrix, the result retains the same dimensions. All other
arguments are recycled as needed. For example, if x has two rows
and 5 columns, then mean might provide 2 values, so that the first/second row
is evaluated under the first/second mean value.
}
\keyword{internal}
