% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_estimate.R
\name{estimate_classical}
\alias{estimate_classical}
\title{Estimate Parameters of a \code{drift_dm} Model via Classical Optimization}
\usage{
estimate_classical(
  drift_dm_obj,
  optimizer,
  start_vals = NULL,
  return_runs = NULL,
  lower = NULL,
  upper = NULL,
  verbose = NULL,
  de_n_cores = 1,
  control = list(),
  round_digits = NULL,
  seed = NULL,
  use_ez = NULL,
  n_lhs = NULL
)
}
\arguments{
\item{drift_dm_obj}{an object inheriting from \link{drift_dm}.}

\item{optimizer}{a character string specifying the optimizer to use.
Must be one of \code{"Nelder-Mead"}, \code{"nmkb"}, \code{"BFGS"}, \code{"L-BFGS-B"}, or \code{"DEoptim"}.}

\item{start_vals}{a set of starting values. Must be compatible with
\code{\link[=get_parameters_smart]{get_parameters_smart()}}. If \code{start_vals}
is not \code{NULL}, the function tries to set the provided parameter values to
the model, using those values as starting values for the optimization routine.
Special case: If start_vals is a \code{data.frame}, the function is recursively
called for each row of \code{start_vals}, providing a handy way to run an
optimization routine with different starting values. Default is \code{NULL},
which implies that the current model parameters are used as starting
values.}

\item{return_runs}{a single logical. Only relevant when \code{start_vals} is
a \code{data.frame} and the optimization routine is called multiple times with
different starting values. If \code{FALSE}, the best-fitting model
is returned. If \code{TRUE}, a list is returned, containing the best-fitting model,
all cost values across runs, and all estimated model parameters across runs.}

\item{lower, upper}{bounds on the parameters to be estimated.
Can be numeric vectors, named vectors, or flexible lists (see Details).}

\item{verbose}{an integer (0, 1, or 2). Controls the amount of printed output.
\itemize{
\item 0 = silent
\item 1 = starting/exiting messages
\item 2 = all parameters and the cost value per iteration
}}

\item{de_n_cores}{an integer > 0. Number of CPU cores to use for \code{DEoptim}.}

\item{control}{a named list of control parameters passed to the chosen
optimizer.}

\item{round_digits}{an integer. Number of digits to round cost values in printed
output. If \code{NULL}, defaults to \code{\link[=drift_dm_default_rounding]{drift_dm_default_rounding()}}.}

\item{seed}{a seed, to make the results of DEoptim reproducible.}
}
\value{
The updated \code{drift_dm_obj}, with optimized parameters.
}
\description{
\code{estimate_classical()} estimates the parameters of a \link{drift_dm}
model by minimizing the model's cost function (e.g., RMSE or negative
log-likelihood) using classical (non-Bayesian) optimization routines.

Available optimizers include:
\itemize{
\item Nelder-Mead (bounded or unbounded): \code{"Nelder-Mead"}, \code{"nmkb"}
(via \code{\link[stats:optim]{stats::optim()}} and \code{\link[dfoptim:nmkb]{dfoptim::nmkb()}}, respectively)
\item BFGS and L-BFGS-B (via \code{\link[stats:optim]{stats::optim()}})
\item Differential Evolution (via \code{\link[DEoptim:DEoptim]{DEoptim::DEoptim()}})
}
}
\details{
\subsection{Search space specification}{

\code{lower} and \code{upper} can be specified flexibly:
\itemize{
\item As unnamed numeric vectors (not recommended unless you're sure of the
parameter order)
\item As named numeric vectors matching the parameter names of the model
\item As lists with a \code{default_values} entry (plus optional condition-specific
entries)
}

This design mirrors the structure used in \code{\link[=simulate_data.drift_dm]{simulate_data.drift_dm()}}.
}

\subsection{Optimization details}{

Some optimizers (i.e., \code{"nmkb"}, \code{"L-BFGS-B"}, \code{"DEoptim"}) require both
\code{lower} and \code{upper} bounds.

Differential Evolution (\code{DEoptim}) supports parallelization across cores via
\code{de_n_cores}. If \code{de_n_cores > 1}, a parallel cluster is created and
automatically closed after optimization.

The cost function being minimized depends on the \code{\link[=cost_function]{cost_function()}}
of the model.

During optimization, failed model evaluations yield a very high
cost value (i.e., \code{.Machine$double.xmax}). In some cases, this ensures that
the optimization doesn't crash, though, this is not guaranteed.
}
}
\keyword{internal}
