% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_bayes_estimate.R
\name{get_default_prior_settings}
\alias{get_default_prior_settings}
\title{Generate Prior Functions for Model Parameters}
\usage{
get_default_prior_settings(
  drift_dm_obj,
  level,
  means = NULL,
  sds = NULL,
  lower = NULL,
  upper = NULL,
  shapes = NULL,
  rates = NULL
)
}
\arguments{
\item{drift_dm_obj}{a \link{drift_dm} model object.}

\item{level}{a character string, specifying the modeling level. Must be one
of: \code{"hyper"} (group-level priors), \code{"lower"} (individual-level priors
given group-level parameters), or \code{"none"} (non-hierarchical setting).}

\item{means}{a named numeric vector or list, specifying the prior means for
each parameter. Missing values will be filled up from the first matching
parameter in \code{drift_dm_obj}}

\item{sds}{a named numeric vector or list of standard deviations. Missing or
\code{NULL} values will be replaced by corresponding values from \code{mean}.}

\item{lower, upper}{optional numeric vectors or lists specifying the lower
and upper truncation bounds for each prior distribution. Defaults to \code{-Inf}
and \code{Inf}, respectively.}

\item{shapes, rates}{optional numeric vectors or lists specifying the shape and
rate parameter for group-level standard deviations (used at the hyper-level).
Defaults to \code{1}.}
}
\value{
A named list with two elements:
\itemize{
\item \code{log_dens_priors}: A named list of functions. Each function returns the
log-density for a parameter value, based on the chosen prior settings.
\item \code{r_priors}: A named list of functions for sampling from the specified
prior distributions.
}
}
\description{
This function creates prior distribution functions for each model parameter
in a drift diffusion model (DDM), depending on the specified hierarchical
level. It returns both log-density functions and, where applicable,
random-sample generators based on the user-defined prior settings.
}
\details{
Each prior is parameter-specific and wrapped using \code{\link[purrr:partial]{purrr::partial()}} so
that downstream sampling or density evaluation can be performed easily.
At the hyper-level, the functions \code{\link[=d_default_prior_hyper]{d_default_prior_hyper()}} and
\code{\link[=r_default_prior_hyper]{r_default_prior_hyper()}} are used. At the lower-level, the
functions \code{\link[=dtnorm]{dtnorm()}} and \code{\link[=rtnorm]{rtnorm()}} are used.

The input arguments \code{means}, \code{sds}, \code{lowers}, \code{uppers}, \code{shapes}, and \code{rates}
are handled by the function \code{\link[=get_parameters_smart]{get_parameters_smart()}}.
}
\seealso{
\code{\link[=get_parameters_smart]{get_parameters_smart()}}, \code{\link[=dtnorm]{dtnorm()}},
\code{\link[=rtnorm]{rtnorm()}}, \code{\link[=d_default_prior_hyper]{d_default_prior_hyper()}},
\code{\link[=r_default_prior_hyper]{r_default_prior_hyper()}}
}
\keyword{internal}
