% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{update_stats_agg}
\alias{update_stats_agg}
\title{Update aggregated statistics in a \code{drift_dm} object}
\usage{
update_stats_agg(
  drift_dm_obj,
  which_cost_function,
  probs = NULL,
  n_bins = NULL
)
}
\arguments{
\item{drift_dm_obj}{a \code{drift_dm} object.}

\item{which_cost_function}{a character string, indicating which cost function
is used. Must be one of \code{\link[=drift_dm_cost_functions]{drift_dm_cost_functions()}}.}

\item{probs}{optional numeric vector of probabilities for quantile
calculation. If \code{NULL}, defaults are taken from
\code{\link[=drift_dm_default_probs]{drift_dm_default_probs()}}.}

\item{n_bins}{an optional integer, giving the number of bins for the CAFs.
If \code{NULL}, defaults are taken from \code{\link[=drift_dm_default_n_bins]{drift_dm_default_n_bins()}}.}
}
\value{
the input \code{drift_dm_obj}, with its \code{stats_agg} and
\code{stats_agg_info} entries updated or removed, depending on the cost
function and availability of observed data
}
\description{
Internal function that creates or updates the aggregated statistics
(\code{stats_agg} and \code{stats_agg_info}) in a \link{drift_dm} object, depending
on the specified cost function. For maximum likelihood estimation
(\code{"neg_log_like"}), aggregated statistics are removed, because the raw
RTs are used directly.
}
\note{
This function is called by \code{\link[=obs_data]{obs_data()}} and
\code{\link[=cost_function]{cost_function()}}
}
\seealso{
\code{\link[=obs_data]{obs_data()}}, \code{\link[=cost_function]{cost_function()}},
\code{\link[=drift_dm]{drift_dm()}}
}
\keyword{internal}
