% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.R
\name{isAcyclic}
\alias{isAcyclic}
\alias{findCycle}
\title{Test for Cycles}
\usage{
isAcyclic(x)

findCycle(x)
}
\arguments{
\item{x}{the input graph, of any graph type.}
}
\description{
\code{isAcyclic(x)} returns \code{TRUE} if the given graph does not contain a directed cycle.
}
\details{
\code{findCycle(x)} will try to find at least one cycle in x and return it as a list of node names.

These functions will only consider simple directed edges in the
given graph.
}
\examples{
g1 <- dagitty("dag{X -> Y -> Z}")
stopifnot( isTRUE(isAcyclic( g1 )) )
g2 <- dagitty("dag{X -> Y -> Z -> X}")
stopifnot( isTRUE(!isAcyclic( g2 )) )
g3 <- dagitty("mag{X -- Y -- Z -- X}")
stopifnot( isTRUE(isAcyclic( g3 )) )
}
