% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dal_tune.R
\name{dal_tune}
\alias{dal_tune}
\title{DAL Tune (base for hyperparameter search)}
\usage{
dal_tune(base_model, folds = 10, ranges)
}
\arguments{
\item{base_model}{base model for tuning}

\item{folds}{number of folds for cross-validation}

\item{ranges}{a list of hyperparameter ranges to explore}
}
\value{
returns a \code{dal_tune} object
}
\description{
Base class for hyperparameter optimization that stores a base model, a fold count,
and a parameter grid. Specializations (classification/regression/clustering) implement the evaluation logic.
}
\details{
Ranges are expanded via \code{expand.grid}, and selection is delegated to \code{select_hyper()} which can be
overridden by subclasses to implement custom criteria.
}
\examples{
#See ?cla_tune for classification tuning
#See ?reg_tune for regression tuning
#See ?ts_tune for time series tuning
}
