% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoenc_e.R
\name{autoenc_e}
\alias{autoenc_e}
\title{Autoencoder - Encode}
\usage{
autoenc_e(
  input_size,
  encoding_size,
  batch_size = 32,
  num_epochs = 1000,
  learning_rate = 0.001
)
}
\arguments{
\item{input_size}{Integer. Number of input features per observation.}

\item{encoding_size}{Integer. Size of the latent (bottleneck) representation.}

\item{batch_size}{Integer. Mini-batch size used during training. Default is 32.}

\item{num_epochs}{Integer. Maximum number of training epochs. Default is 1000.}

\item{learning_rate}{Numeric. Optimizer learning rate. Default is 0.001.}
}
\value{
A \code{autoenc_e} object.
}
\description{
Creates a deep learning autoencoder that learns a latent representation (encoding)
for a sequence of observations. Wraps a PyTorch implementation via the \code{reticulate} bridge.
}
\details{
This encoder provides dimensionality reduction by training a neural network to
compress inputs into a lower-dimensional bottleneck. The learned encoding can be used
for downstream tasks such as clustering, visualization, or as features for predictive models.
}
\examples{
\dontrun{
# Requirements: Python with torch installed and reticulate configured.
set.seed(123)

# 1) Create a toy dataset with 100 samples and 20 features
X <- matrix(rnorm(2000), nrow = 100, ncol = 20)

# 2) Create and fit an encoder (5-D bottleneck)
ae <- autoenc_e(input_size = 20, encoding_size = 5, num_epochs = 50)
ae <- daltoolbox::fit(ae, X)

# 3) Transform data to latent space
Z <- daltoolbox::transform(ae, X)   # matrix with dimensions 100 x 5
dim(Z)                              # c(100, 5)
}

# See a more complete example at:
# https://github.com/cefet-rj-dal/daltoolbox/blob/main/autoencoder/autoenc_e.md

}
\references{
Hinton, G. E., & Salakhutdinov, R. R. (2006). Reducing the Dimensionality of Data with Neural Networks.
Paszke, A., et al. (2019). PyTorch: An Imperative Style, High-Performance Deep Learning Library.
}
