% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.diagnostics.sim.r
\name{gl.diagnostics.sim}
\alias{gl.diagnostics.sim}
\title{Comparing simulations against theoretical expectations}
\usage{
gl.diagnostics.sim(
  x,
  Ne,
  iteration = 1,
  pop_he = 1,
  pops_fst = c(1, 2),
  plot_theme = theme_dartR(),
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Output from function \code{\link{gl.sim.WF.run}} [required].}

\item{Ne}{Effective population size to use as input to compare theoretical 
expectations [required].}

\item{iteration}{Iteration number to analyse [default 1].}

\item{pop_he}{Population name in which the rate of loss of heterozygosity is
going to be compared against theoretical expectations [default 1].}

\item{pops_fst}{Pair of populations in which FST is going to be compared 
against theoretical expectations [default c(1,2)].}

\item{plot_theme}{User specified theme [default theme_dartR()].}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{plot.dir}{Directory in which to save files [default = working directory]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default NULL, unless specified using gl.set.verbosity].}
}
\value{
Returns plots comparing simulations against theoretical expectations
}
\description{
Comparing simulations against theoretical expectations
}
\details{
Two plots are presented comparing the simulations against theoretical 
expectations:

\enumerate{
\item Expected heterozygosity under neutrality (Crow & Kimura, 1970, p. 329) is 
 calculated as:
 
Het = He0(1-(1/2Ne))^t,

where Ne is effective population size, He0  is heterozygosity at generation 0
 and t is the number of generations.

\item Expected FST under neutrality (Takahata, 1983) is calculated as:

FST=1/(4Nem(n/(n-1))^2+1),

where Ne is effective populations size of each individual subpopulation, m is
dispersal rate and n the number of subpopulations (always 2).
}
}
\examples{
\donttest{
ref_table <- gl.sim.WF.table(file_var=system.file('extdata', 
'ref_variables.csv', package = 'dartR.sim'),interactive_vars = FALSE)

res_sim <- gl.sim.WF.run(file_var = system.file('extdata',
 'sim_variables.csv', package ='dartR.sim'),ref_table=ref_table,
 interactive_vars = FALSE,number_pops_phase2=2,population_size_phase2="10 10")
 
 res <- gl.diagnostics.sim(x=res_sim, Ne=10)
 }
}
\references{
\itemize{
\item Crow JF, Kimura M. An introduction to population genetics theory. An 
introduction to population genetics theory. 1970.
\item Takahata N. Gene identity and genetic differentiation of populations in 
the finite island model. Genetics. 1983;104(3):497-512.
 }
}
\author{
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
