% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.callrate.r
\name{gl.filter.callrate}
\alias{gl.filter.callrate}
\title{Filters loci or specimens in a genlight \{adegenet\} object based on
call rate}
\usage{
gl.filter.callrate(
  x,
  method = "loc",
  threshold = 0.95,
  mono.rm = FALSE,
  recalc = FALSE,
  recursive = FALSE,
  plot.out = TRUE,
  plot_theme = theme_dartR(),
  plot_colors = two_colors,
  bins = 25,
  save2tmp = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data, or the genind
object containing the SilocoDArT data [required].}

\item{method}{Use method='loc' to specify that loci are to be filtered, 'ind'
to specify that specimens are to be filtered, 'pop' to remove loci that 
fail to meet the specified threshold in any one population [default 'loc'].}

\item{threshold}{Threshold value below which loci will be removed
[default 0.95].}

\item{mono.rm}{Remove monomorphic loci after analysis is complete
[default FALSE].}

\item{recalc}{Recalculate the locus metadata statistics if any individuals
are deleted in the filtering [default FALSE].}

\item{recursive}{Repeatedly filter individuals on call rate, each time
removing monomorphic loci. Only applies if method='ind' and mono.rm=TRUE
 [default FALSE].}

\item{plot.out}{Specify if histograms of call rate, before and after, are to
be produced [default TRUE].}

\item{plot_theme}{User specified theme for the plot [default theme_dartR()].}

\item{plot_colors}{List of two color names for the borders and fill of the
plots [default two_colors].}

\item{bins}{Number of bins to display in histograms [default 25].}

\item{save2tmp}{If TRUE, saves any ggplots and listings to the session
temporary directory (tempdir) [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
The reduced genlight or genind object, plus a summary
}
\description{
SNP datasets generated by DArT have missing values primarily arising from
failure to call a SNP because of a mutation at one or both of the restriction
enzyme recognition sites. The script gl.filter.callrate() will filter out the
 loci with call rates below a specified threshold.

Tag Presence/Absence datasets (SilicoDArT) have missing values where it is
not possible to determine reliably if there the sequence tag can be called at
a particular locus.
}
\details{
Because this filter operates on call rate, this function recalculates Call
Rate, if necessary, before filtering. If individuals are removed using
method='ind', then the call rate stored in the genlight object is, 
optionally,
recalculated after filtering.

Note that when filtering individuals on call rate, the initial call rate is
calculated and compared against the threshold. After filtering, if
mono.rm=TRUE, the removal of monomorphic loci will alter the call rates.
Some individuals with a call rate initially greater than the nominated
threshold, and so retained, may come to have a call rate lower than the
threshold. If this is a problem, repeated iterations of this function will
resolve the issue. This is done by setting mono.rm=TRUE and recursive=TRUE,
or it can be done manually.

Callrate is summarized by locus or by individual to allow sensible decisions
on thresholds for filtering taking into consideration consequential loss of
data. The summary is in the form of a tabulation and plots.

Plot themes can be obtained from \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \item
 \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }

Resultant ggplot(s) and the tabulation(s) are saved to the session's
 temporary directory.
}
\examples{
 \donttest{
# SNP data
  result <- gl.filter.callrate(testset.gl[1:10], method='loc', threshold=0.8,
   verbose=3)
  result <- gl.filter.callrate(testset.gl[1:10], method='ind', threshold=0.8,
   verbose=3)
  result <- gl.filter.callrate(testset.gl[1:10], method='pop', threshold=0.8,
   verbose=3)
# Tag P/A data
  result <- gl.filter.callrate(testset.gs[1:10], method='loc', 
  threshold=0.95, verbose=3)
  result <- gl.filter.callrate(testset.gs[1:10], method='ind', 
  threshold=0.8, verbose=3)
  result <- gl.filter.callrate(testset.gs[1:10], method='pop', 
  threshold=0.8, verbose=3)
  }
  res <- gl.filter.callrate(platypus.gl)

}
\seealso{
\code{\link{gl.report.callrate}}

Other filter functions: 
\code{\link{gl.filter.allna}()},
\code{\link{gl.filter.heterozygosity}()},
\code{\link{gl.filter.hwe}()},
\code{\link{gl.filter.locmetric}()},
\code{\link{gl.filter.maf}()},
\code{\link{gl.filter.monomorphs}()},
\code{\link{gl.filter.overshoot}()},
\code{\link{gl.filter.pa}()},
\code{\link{gl.filter.parent.offspring}()},
\code{\link{gl.filter.rdepth}()},
\code{\link{gl.filter.reproducibility}()},
\code{\link{gl.filter.secondaries}()},
\code{\link{gl.filter.sexlinked}()},
\code{\link{gl.filter.taglength}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{filter functions}
