% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.maf.r
\name{gl.report.maf}
\alias{gl.report.maf}
\title{Reports minor allele frequency (MAF) for each locus in a SNP dataset}
\usage{
gl.report.maf(
  x,
  maf.limit = 0.5,
  ind.limit = 5,
  plot.out = TRUE,
  plot_theme = theme_dartR(),
  plot_colors_pop = discrete_palette,
  plot_colors_all = two_colors,
  bins = 25,
  save2tmp = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{maf.limit}{Show histograms MAF range <= maf.limit [default 0.5].}

\item{ind.limit}{Show histograms only for populations of size greater than
ind.limit [default 5].}

\item{plot.out}{Specify if plot is to be produced [default TRUE].}

\item{plot_theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot_colors_pop}{A color palette for population plots
[default discrete_palette].}

\item{plot_colors_all}{List of two color names for the borders and fill of
the overall plot [default two_colors].}

\item{bins}{Number of bins to display in histograms [default 25].}

\item{save2tmp}{If TRUE, saves any ggplots and listings to the session
temporary directory (tempdir) [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default NULL, unless specified using gl.set.verbosity].}
}
\value{
An unaltered genlight object
}
\description{
This script provides summary histograms of MAF for each
population in the dataset and an overall histogram to assist the decision of
choosing thresholds for the filter function \code{\link{gl.filter.maf}}
}
\details{
The function \code{\link{gl.filter.maf}} will filter out the
 loci with MAF below a specified threshold.

\strong{ Function's output }

 The minimum, maximum, mean and a tabulation of MAF quantiles against
 thresholds rate are provided. Output also includes a boxplot and a
 histogram.

 This function reports the
 MAF for each of several quantiles. Quantiles are
 partitions of a finite set of values into q subsets of (nearly) equal sizes.
 In this function q = 20. Quantiles are useful measures because they are less
 susceptible to long-tailed distributions and outliers.

 Plots and table are saved to the temporal directory (tempdir) and can be
 accessed with the function \code{\link{gl.print.reports}} and listed with
 the function \code{\link{gl.list.reports}}. Note that they can be accessed
 only in the current R session because tempdir is cleared each time that the
  R session is closed.

Examples of other themes that can be used can be consulted in \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \item
 \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }
}
\examples{
gl <- gl.report.maf(platypus.gl)
}
\seealso{
\code{\link{gl.filter.maf}}, \code{\link{gl.list.reports}},
 \code{\link{gl.print.reports}}

Other report functions: 
\code{\link{gl.report.bases}()},
\code{\link{gl.report.callrate}()},
\code{\link{gl.report.diversity}()},
\code{\link{gl.report.hamming}()},
\code{\link{gl.report.hwe}()},
\code{\link{gl.report.ld.map}()},
\code{\link{gl.report.locmetric}()},
\code{\link{gl.report.monomorphs}()},
\code{\link{gl.report.overshoot}()},
\code{\link{gl.report.pa}()},
\code{\link{gl.report.parent.offspring}()},
\code{\link{gl.report.rdepth}()},
\code{\link{gl.report.replicates}()},
\code{\link{gl.report.reproducibility}()},
\code{\link{gl.report.secondaries}()},
\code{\link{gl.report.sexlinked}()},
\code{\link{gl.report.taglength}()}
}
\author{
Custodian: Arthur Georges (Post to 
\url{https://groups.google.com/d/forum/dartr})
}
\concept{report functions}
