% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.dart2genlight.r
\name{utils.dart2genlight}
\alias{utils.dart2genlight}
\title{Converts DarT to genlight.}
\usage{
utils.dart2genlight(
  dart,
  ind.metafile = NULL,
  covfilename = NULL,
  probar = TRUE,
  verbose = NULL
)
}
\arguments{
\item{dart}{A dart object created via read.dart [required].}

\item{ind.metafile}{Optional file in csv format with metadata for each
individual (see details for explanation) [default NULL].}

\item{covfilename}{Depreciated, use parameter ind.metafile.}

\item{probar}{Show progress bar [default TRUE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report [default NULL].}
}
\value{
A genlight object. Including all available slots are filled.
loc.names, ind.names, pop, lat, lon (if provided via the ind.metadata file)
}
\description{
Converts a DArT file (read via \code{read.dart}) into an
genlight object \code{adegenet}.
}
\details{
The ind.metadata file needs to have very specific headings. First a heading
called id. Here the ids have to match the ids in the dartR object. 
The following column headings are optional.
pop: specifies the population membership of each individual. lat and lon
specify spatial coordinates (in decimal degrees WGS1984 format). Additional
columns with individual metadata can be imported (e.g. age, gender).
}
\author{
Custodian: Bernd Gruber (Post to \url{https://groups.google.com/d/forum/dartr})
}
