% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{oils.int}
\alias{oils.int}
\title{Oils and Fats Interval Dataset}
\format{
A data frame with 8 observations and 4 interval-valued variables:
\itemize{
    \item \code{specific_gravity}: Specific gravity of the oil/fat.
    \item \code{freezing_point}: Freezing point (degrees Celsius).
    \item \code{iodine_value}: Iodine value.
    \item \code{saponification_value}: Saponification value.
}
}
\usage{
data(oils.int)
}
\description{
Classic benchmark interval-valued data for 8 oils and fats described
by 4 physico-chemical properties. Originally from Ichino (1988).
}
\details{
The 8 samples are: Linseed oil, Perilla oil, Cottonseed oil, Sesame oil,
Camellia oil, Olive oil, Beef tallow, Hog fat. The expected 3-cluster
structure is: \{Beef tallow, Hog fat\}, \{Cottonseed, Sesame, Camellia,
Olive\}, and \{Linseed, Perilla\}. Widely used for comparing clustering
methods and distance measures in symbolic data analysis.
}
\examples{
data(oils.int)
}
\references{
Ichino, M. (1988). General metrics for mixed features. \emph{Proc. IEEE
Conf. Systems, Man, and Cybernetics}, pp. 494-497.

Diday, E. and Noirhomme-Fraiture, M. (Eds.) (2008). \emph{Symbolic Data
Analysis and the SODAS Software}. Wiley. Table 13.7, p.253.
}
\keyword{clustering}
\keyword{datasets}
\keyword{interval}
