% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\name{getDataObject}
\alias{getDataObject}
\alias{getDataObject,D1Client-method}
\title{Download a file (and it's associated system metadata) from the DataONE Federation as a DataObject.}
\usage{
getDataObject(x, identifier, ...)

\S4method{getDataObject}{D1Client}(
  x,
  identifier,
  lazyLoad = FALSE,
  limit = "1MB",
  quiet = TRUE,
  checksumAlgorithm = as.character(NA)
)
}
\arguments{
\item{x}{A D1Client object.}

\item{identifier}{The identifier of the object to get.}

\item{...}{(not yet used)}

\item{lazyLoad}{A \code{logical} value. If TRUE, then only package member system metadata is downloaded and not data.}

\item{limit}{A \code{character} value specifying maximum package member size to download. Specified with "KB", "MB" or "TB"
for example: "100KB", "10MB", "20GB", "1TB". The default is "1MB". Only takes effect if 'lazyLoad=FALSE'.}

\item{quiet}{A \code{'logical'}. If TRUE (the default) then informational messages will not be printed.}

\item{checksumAlgorithm}{A \code{character} value specifying the algorithm to use to re-calculate (after download) the system metadata checksum
for the object's data bytes for example: "SHA-256". The default is "NA", which specifies that this
re-calculation will not be performed.}
}
\value{
A DataObject or NULL if the object was not found in DataONE
}
\description{
A convenience method to download a data object and its associated SystemMetadata, wrapped
in a DataObject class.
}
\details{
This method performs multiple underlying calls to the DataONE repository network.
CN.resolve() is called to locate the object on one or more repositories, and then each of these
is accessed until the associated SystemMetadata and data bytes are successfully downloaded. This
data is then used to construct the returned DataObject. This function replaces the previous
getD1Object() method in the version 1
dataone library. \cr\cr
The \code{lazyLoad} parameter controls whether the data byes for a DataONE item are downloaded (the system
metadata is always downloaded). When \code{lazyLoad}=FALSE,the \code{limit} parameter can be used to specify
the maximum size of a data file that will be downloaded. If \code{lazyLoad} is TRUE, then \code{limit}
is ignored. The \code{lazyLoad} and \code{limit} can be used together in the following ways:

\tabular{lllll}{
\tab 'lazyLoad' \tab 'limit' \tab result \tab comments \cr
\tab ---------- \tab ------- \tab ------ \tab --------------------- \cr
\tab TRUE \tab Any value \tab Data bytes are not downloaded \tab The 'limit' parameter is ignored \cr
\tab FALSE \tab Not specified \tab Data bytes are download if less than 1MB \tab The default 'limit' of 1MB is used \cr
\tab FALSE \tab 10MB \tab Data bytes are downloaded if less than 10MB \tab The specified 'limit' values is used \cr
}

Note that DataONE system metadata is always downloaded and populated into the resulting DataObject, regardless
of the 'lazyLoad' and 'limit' values specified in the call to 'getDataObject()'.
}
\examples{
\dontrun{
library(dataone)
d1c <- D1Client("PROD", "urn:node:KNB")
pid <- "solson.5.1"
obj <- getDataObject(d1c, pid)
data <- getData(obj)
}
}
\seealso{
\code{\link[=D1Client-class]{D1Client()}} class description.
}
