% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_attributes.R
\name{validate_file_paths}
\alias{validate_file_paths}
\title{Validate file paths}
\usage{
validate_file_paths(data_path = "data", ...)
}
\arguments{
\item{data_path}{character vector of either:
\enumerate{
\item path(s) to the data file(s).
\item single path to directory containing data file(s).
Currently only tabular \code{.csv} and \code{.tsv} files are supported. Alternatively
attributes returned using \code{names()} can be extracted from r object, stored as
\code{.rds} files.
}}

\item{...}{parameters passed to \code{list.files()}. For example, use
\code{recursive = TRUE} to list files in a folder recursively or use \code{pattern} to
filter files for patterns.}
}
\value{
One or more data file paths
}
\description{
Helper function to return a set of file paths for use in other functions
}
\examples{
\dontrun{
# Assuming some data files in "./data"
my_files <- validate_file_paths()

# If your data files are in `another_folder`
my_files <- validate_file_paths("another_folder")
}
}
