% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_fails}
\alias{filter_fails}
\title{Filters a result dataset for the values that failed the verification}
\usage{
filter_fails(res, x, per_rule = FALSE)
}
\arguments{
\item{res}{a result data.frame as outputted from \code{\link[=check_data]{check_data()}} or a ruleset}

\item{x}{a dataset that was used in \code{\link[=check_data]{check_data()}}}

\item{per_rule}{if set to TRUE, a list of filtered data is returned, one for
each failed verification rule. If set to FALSE, a data.frame is returned of
the values that fail any rule.}
}
\value{
the dataset with the entries that did not match the given rules
}
\description{
Filters a result dataset for the values that failed the verification
}
\examples{
rules <- ruleset(
  rule(mpg > 10 & mpg < 30), # mpg goes up to 34
  rule(cyl \%in\% c(4, 8)), # missing 6 cyl
  rule(vs \%in\% c(0, 1), allow_na = TRUE)
)

res <- check_data(mtcars, rules)

filter_fails(res, mtcars)
filter_fails(res, mtcars, per_rule = TRUE)

# alternatively, the first argument can also be a ruleset
filter_fails(rules, mtcars)
filter_fails(rules, mtcars, per_rule = TRUE)
}
