% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daterangepicker.R
\name{daterangepickerOptions}
\alias{daterangepickerOptions}
\title{daterangepickerOptions}
\usage{
daterangepickerOptions(
  minYear = NULL,
  maxYear = NULL,
  showDropdowns = TRUE,
  showCustomRangeLabel = TRUE,
  opens = c("right", "left", "center"),
  drops = c("down", "up"),
  timePicker = FALSE,
  timePickerIncrement = 1,
  timePicker24Hour = FALSE,
  timePickerSeconds = FALSE,
  showWeekNumbers = FALSE,
  showISOWeekNumbers = FALSE,
  parentEl = NULL,
  maxSpan = NULL,
  alwaysShowCalendars = FALSE,
  buttonClasses = NULL,
  applyButtonClasses = NULL,
  cancelButtonClasses = NULL,
  cancelIsClear = FALSE,
  locale = NULL,
  singleDatePicker = FALSE,
  autoApply = FALSE,
  linkedCalendars = TRUE,
  autoUpdateInput = TRUE,
  ...
)
}
\arguments{
\item{minYear}{The minimum year as numeric shown in the dropdowns when
showDropdowns is set to \code{TRUE}}

\item{maxYear}{The maximum year as numeric shown in the dropdowns when
showDropdowns is set to \code{TRUE}}

\item{showDropdowns}{Show year and month select boxes above calendars to jump
to a specific month and year.}

\item{showCustomRangeLabel}{Displays "Custom Range" at the end of the list of
predefined ranges, when the ranges option is used. This option will be
highlighted whenever the current date range selection does not match one of
the predefined ranges. Clicking it will display the calendars to select a
new range.}

\item{opens}{Whether the picker appears aligned to the \code{left}, to the
\code{right}, or to the \code{center} under the HTML element it's attached
to.}

\item{drops}{Whether the picker appears below (\code{down}) or above
(\code{up}) the HTML element it's attached to. Default is \code{down}}

\item{timePicker}{Adds select boxes to choose times in addition to dates.}

\item{timePickerIncrement}{Increment of the minutes selection list for times
(i.e. 30 to allow only selection of times ending in 0 or 30).}

\item{timePicker24Hour}{Use 24-hour instead of 12-hour times, removing the
AM/PM selection.}

\item{timePickerSeconds}{Show seconds in the timePicker.}

\item{showWeekNumbers}{Show localized week numbers at the start of each week
on the calendars.}

\item{showISOWeekNumbers}{Show ISO week numbers at the start of each week on
the calendars.}

\item{parentEl}{jQuery selector of the parent element that the date range
picker will be added to, if not provided this will be 'body'}

\item{maxSpan}{The maximum span between the selected start and end dates as
List or table. You can provide any object the moment library would let you
add to a date.}

\item{alwaysShowCalendars}{Normally, if you use the ranges option to specify
pre-defined date ranges, calendars for choosing a custom date range are not
shown until the user clicks "Custom Range". When this option is set to
\code{TRUE}, the calendars for choosing a custom date range are always
shown instead.}

\item{buttonClasses}{CSS class names that will be added to both the apply and
cancel buttons.}

\item{applyButtonClasses}{CSS class names that will be added only to the
apply button.}

\item{cancelButtonClasses}{CSS class names that will be added only to the
cancel button.}

\item{cancelIsClear}{If TRUE, will treat the Cancel Button like a Clear
Button.}

\item{locale}{Allows you to provide localized strings for buttons and labels,
customize the date format, and change the first day of week for the
calendars. See the examples in `./inst/examples/`}

\item{singleDatePicker}{Show only a single calendar to choose one date,
instead of a range picker with two calendars. The start and end dates
provided to your callback will be the same single date chosen.}

\item{autoApply}{Hide the apply and cancel buttons, and automatically apply a
new date range as soon as two dates are clicked.}

\item{linkedCalendars}{When enabled, the two calendars displayed will always
be for two sequential months (i.e. January and February), and both will be
advanced when clicking the left or right arrows above the calendars. When
disabled, the two calendars can be individually advanced and display any
month/year.}

\item{autoUpdateInput}{Indicates whether the date range picker should
automatically update the value of the <input> element it's attached to at
initialization and when the selected dates change.}

\item{...}{Further arguments passed to `daterangepicker`, like
\code{isInvalidDate} or \code{isCustomDate}.}
}
\description{
Update the daterangepicker
}
\seealso{
\href{https://www.daterangepicker.com/#config}{www.daterangepicker.com}

Other daterangepicker Functions: 
\code{\link{daterangepicker}()},
\code{\link{updateDaterangepicker}()}
}
\concept{daterangepicker Functions}
