% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datplot_utility.R
\name{create.sub.objects}
\alias{create.sub.objects}
\title{Create sub-objects for each object in a dataframe (internal)}
\usage{
create.sub.objects(DAT_list, stepsize, calc = "weight", cumulative = FALSE)
}
\arguments{
\item{DAT_list}{a list as prepared by [datsteps()]}

\item{stepsize}{numeric, default is 1. Number of years that should be used
as an interval for creating dating steps.}

\item{calc}{method of calculation to use;
can be either one of "weight" (default) or "probability":
 * "weight": use the
    [published original calculation](https://doi.org/10.1017/aap.2021.8)
    for weights,
 * "probability": calculate year-wise probability instead (only reasonable
    when `stepsize = 1`)}

\item{cumulative}{FALSE (default), TRUE: add a column containing the
cumulative probability for each object (only reasonable when `stepsize = 1`,
and will automatically use probability calculation)}
}
\value{
an expanded list of the same structure to be further processed by
[datsteps()] each object duplicated according to the number of steps required
}
\description{
Requires a list with named vectors as [datsteps()] will
hand to the function.
}
\keyword{internal}
