% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datplot_utility.R
\name{get.step.sequence}
\alias{get.step.sequence}
\title{Calculate the sequence of dating steps}
\usage{
get.step.sequence(datmin = 0, datmax = 100, stepsize = 25)
}
\arguments{
\item{datmin}{numeric value of the minimum dating of one object}

\item{datmax}{numeric value of the maximum dating of one object}

\item{stepsize}{the stepsize to be used}
}
\value{
sequence of steps to be created by [create.sub.objects()]
}
\description{
Produces an appropriate sequence of years between the minimum
and maximum dating.

If they cannot be properly divided by the stepsize set
beforehand, either three values are generated for objects that are dated to
a range of more then 60% of the stepsize (min, mean, max), or two values for
objects dated to a timespan of less or equal to 60% of the stepsize.
If they can be divided without residual, the normal sequence is returned.
If there is a residual, the stepsize is modified depending on how large the
residual is.
}
\examples{
min_year <- -494
max_year <- -334
sequence <- get.step.sequence(datmin = min_year, datmax = max_year, stepsize = 25)
sequence

min_year <- 1
max_year <- 100
sequence <- get.step.sequence(datmin = min_year, datmax = max_year, stepsize = 25)
sequence
}
\seealso{
[datsteps()], [create.sub.objects()]
}
