data("DAT_df")
DAT_df_steps <- datsteps(DAT_df[4:5, ], stepsize = 25, verbose = FALSE)

test_that("works with defaults for df generated by datsteps", {
  expect_true(inherits(scaleweight(DAT_df_steps), "data.frame"))
})

test_that("works with column name", {
  expect_equal(scaleweight(DAT_df_steps, var = "variable"),
               scaleweight(DAT_df_steps, var = 2))
  expect_equal(scaleweight(DAT_df_steps, val = "weight"),
               scaleweight(DAT_df_steps, val = 5))
})

test_that("fails on non-existent column name", {
  expect_error(scaleweight(DAT_df_steps, val = "börek"), "column")
  expect_error(scaleweight(DAT_df_steps, var = "börek"), "column")
})

test_that("fails on non-existent column index", {
  expect_error(scaleweight(DAT_df_steps, val = 12), "column")
  expect_error(scaleweight(DAT_df_steps, var = 12), "column")
})

test_that("fails if value-column is not numeric", {
  expect_error(scaleweight(DAT_df_steps, val = 2), "numeric")
})

test_that("attribute description is altered correctly", {
  test <- scaleweight(DAT_df_steps, var = "all", val = "weight")
  expect_match(as.character(attributes(test$weight)),
               "(scaled to sum of all objects)")
  test <- scaleweight(DAT_df_steps, var = "variable", val = "weight")
  expect_match(as.character(attributes(test$weight)),
               "grouped by column")
})


test_that("attribute description is altered correctly", {
  test <- scaleweight(DAT_df_steps, var = "all", val = "weight")
  expect_equal(sum(test$weight), 1)
  test <- scaleweight(DAT_df_steps, var = 2, val = "weight")
  expect_equal(sum(test$weight), length(unique(test$variable)))
})
