% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_daymet_ncss.r
\name{download_daymet_ncss}
\alias{download_daymet_ncss}
\title{Function to geographically subset 'Daymet' regions exceeding tile limits}
\usage{
download_daymet_ncss(
  location = c(34, -82, 33.75, -81.75),
  start = 1980,
  end = 1980,
  param = "tmin",
  frequency = "daily",
  mosaic = "na",
  path = tempdir(),
  silent = FALSE,
  force = FALSE,
  ssl = TRUE
)
}
\arguments{
\item{location}{location of a bounding box c(lat, lon, lat, lon) defined
by a top left and bottom-right coordinates}

\item{start}{start of the range of years over which to download data}

\item{end}{end of the range of years over which to download data}

\item{param}{climate variable you want to download vapour pressure (vp), 
minimum and maximum temperature (tmin,tmax), snow water equivalent (swe), 
solar radiation (srad), precipitation (prcp) , day length (dayl).
The default setting is ALL, this will download all the previously mentioned
climate variables.}

\item{frequency}{frequency of the data requested (default = "daily", other
options are "monthly" or "annual").}

\item{mosaic}{which tile mosiac to source from (na = Northern America,
hi = Hawaii, pr = Puerto Rico), defaults to "na".}

\item{path}{directory where to store the downloaded data 
(default = tempdir())}

\item{silent}{suppress the verbose output}

\item{force}{\code{TRUE} or \code{FALSE} (default),
override the conservative end year setting}

\item{ssl}{\code{TRUE} (default) or \code{FALSE},
override default SSL settings in case of CA issues}
}
\value{
netCDF data file of an area circumscribed by the location bounding
box
}
\description{
Function to geographically subset 'Daymet' regions exceeding tile limits
}
\examples{

\dontrun{
# The following call allows you to subset gridded
# Daymet data using a bounding box location. This
# is an alternative way to query gridded data. The
# routine is particularly helpful if you need certain
# data which stradles boundaries of multiple tiles
# or a smaller subset of a larger tile. Keep in mind
# that there is a 6GB upper limit to the output file
# so querying larger regions will result in an error.
# To download larger areas use the download_daymet_tiles()
# function.

# Download a subset of a / multiple tiles
# into your current working directory.
download_daymet_ncss(location = c(34, -82, 33.75, -81.75),
                      start = 1980,
                      end = 1980,
                      param = "tmin",
                      path = tempdir())
                      
# For other practical examples consult the included
# vignette. 
}
}
