% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbn_inference.R
\name{forecast_ts}
\alias{forecast_ts}
\title{Performs forecasting with the GDBN over a dataset}
\usage{
forecast_ts(
  dt,
  fit,
  size = NULL,
  obj_vars,
  ini = 1,
  len = dim(dt)[1] - ini,
  rep = 1,
  num_p = 50,
  print_res = TRUE,
  plot_res = TRUE,
  mode = "exact",
  prov_ev = NULL
)
}
\arguments{
\item{dt}{data.table object with the TS data}

\item{fit}{dbn.fit object}

\item{size}{number of time slices of the net. Deprecated, will be removed in the future}

\item{obj_vars}{variables to be predicted}

\item{ini}{starting point in the dataset to forecast.}

\item{len}{length of the forecast}

\item{rep}{number of times to repeat the approximate forecasting}

\item{num_p}{number of particles in the approximate forecasting}

\item{print_res}{if TRUE prints the mae and sd metrics of the forecast}

\item{plot_res}{if TRUE plots the results of the forecast}

\item{mode}{"exact" for exact inference, "approx" for approximate}

\item{prov_ev}{variables to be provided as evidence in each forecasting step}
}
\value{
a list with the original time series values and the results of the forecast
}
\description{
Given a dbn.fit object, the size of the net and a folded dataset,
performs a forecast over the initial evidence taken from the dataset.
}
\examples{
size = 3
data(motor)
dt_train <- motor[200:900]
dt_val <- motor[901:1000]
obj <- c("pm_t_0")
net <- learn_dbn_struc(dt_train, size)
f_dt_train <- fold_dt(dt_train, size)
f_dt_val <- fold_dt(dt_val, size)
fit <- fit_dbn_params(net, f_dt_train, method = "mle-g")
res <- suppressWarnings(forecast_ts(f_dt_val, fit, 
        obj_vars = obj, len = 10, print_res = FALSE, plot_res = FALSE))
}
