#include <R.h>
#include <Rinternals.h>
#include <stdlib.h> // for NULL
#include <R_ext/Rdynload.h>

/* .Fortran calls */
extern void F77_NAME(dcsvm_gauss)(double *alpha, double *lam2, double *hval, 
  int *nobs,int *nvars, double *x, double *y, int *jd, int *pfncol, double *pf, 
  double *pf2, int *dfmax, int *pmax, int *nlam, double *flmin, double *ulam, 
  double *eps, int *isd, int *maxit, int *istrong, int *nalam, double *b0, 
  double *beta, int *ibeta, int *nbeta, double *alam, int *npass, int *jerr);

extern void F77_NAME(dcsvm_unif)(double *alpha, double *lam2, double *hval, 
  int *nobs,int *nvars, double *x, double *y, int *jd, int *pfncol, double *pf, 
  double *pf2, int *dfmax, int *pmax, int *nlam, double *flmin, double *ulam, 
  double *eps, int *isd, int *maxit, int *istrong, int *nalam, double *b0, 
  double *beta, int *ibeta, int *nbeta, double *alam, int *npass, int *jerr);

extern void F77_NAME(dcsvm_epane)(double *alpha, double *lam2, double *hval, 
  int *nobs,int *nvars, double *x, double *y, int *jd, int *pfncol, double *pf, 
  double *pf2, int *dfmax, int *pmax, int *nlam, double *flmin, double *ulam, 
  double *eps, int *isd, int *maxit, int *istrong, int *nalam, double *b0, 
  double *beta, int *ibeta, int *nbeta, double *alam, int *npass, int *jerr);


static const R_FortranMethodDef FortranEntries[] = {
    {"dcsvm_gauss", (DL_FUNC) &F77_SUB(dcsvm_gauss), 28},
    {"dcsvm_unif", (DL_FUNC) &F77_SUB(dcsvm_unif), 28},
    {"dcsvm_epane", (DL_FUNC) &F77_SUB(dcsvm_epane), 28},
    {NULL, NULL, 0}
};

void R_init_dcsvm(DllInfo *dll)
{
    R_registerRoutines(dll, NULL, NULL, FortranEntries, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
