% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfl_decompose.R
\name{select_observations_to_be_trimmed}
\alias{select_observations_to_be_trimmed}
\title{Select observations with little common support to be trimmed}
\usage{
select_observations_to_be_trimmed(
  reweighting_factor,
  group_variable,
  group,
  trimming_threshold = NULL
)
}
\arguments{
\item{reweighting_factor}{Estimated reweigting factor}

\item{group_variable}{Variable identifying the reference and comparison group, respectively.}

\item{group}{Identifier of reference group}

\item{trimming_threshold}{threshold defining the maximal accepted relative weight of a reweighting factor/observation. If `NULL`, the threshold is set to `sqrt(N)/N`, where N is the number of observations in the reference group.}
}
\description{
This function implements the trimming rule proposed by Huber, Lechner,
and Wunsch (2014). Observations above the trimming threshold are trimmed in
the reference group and in the comparison group. Per default, the timming
is set to sqrt(N)/N, where N is the number of observation in the  reweighted
reference group. The function returns vector index of observation to be trimmed.
}
