% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVsteps.R
\name{IVsteps}
\alias{IVsteps}
\title{Calculate steps of IV curve}
\usage{
IVsteps(I, V, k = 7, diff_slp = 0.01, plot.option = FALSE)
}
\arguments{
\item{I}{A vector of current values from IV data frame}

\item{V}{A vector of voltage values from IV data frame}

\item{k}{The number of equally-spaced values to supply as starting values for the breakpoints. The default is 7.}

\item{diff_slp}{The difference between the slope on the left and on the right of the change point. The default is 0.01.}

\item{plot.option}{True/False, it plots the IV curve. The default is false.}
}
\value{
a list of the following items:
\itemize{
 \item "step": a value that shows how many steps of IV curve
 \item "xsep": a vector of values (voltage) that shows the change point indicating steps. NA means that the IV curve has only one step and there is no change points.
}
}
\description{
Calculate steps of IV curve
}
\examples{
#this IV curve is of step=1
#load the data provided in the package
data(IV_step1)
IV1 <- data.frame(IV_step1)
result <- IVsteps(IV1$I,IV1$V)
#use the IV curve with step=2
data(IV_step2)
IV2 <- data.frame(IV_step2)
#with plot.option=TRUE, IV curve and steps are ploted
result2 <- IVsteps(IV2$I,IV2$V,plot.option=TRUE)

}
