% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plant_growth.R
\name{plant_growth}
\alias{plant_growth}
\title{Visualize Plant Growth Using D3}
\usage{
plant_growth(
  fill_level = 0.5,
  potWidth = 100,
  potHeight = 40,
  plantMaxHeight = 150,
  stemColor = "#228B22",
  potColor = "#8B4513",
  flowerColor = "#FF69B4",
  strokeColor = "#333",
  strokeWidth = 2,
  renderFillLabel = TRUE,
  titleText = "Plant Growth",
  titleColor = "#333",
  titleFontSize = "14px",
  font = "sans-serif"
)
}
\arguments{
\item{fill_level}{Numeric between 0 and 1 indicating growth level.}

\item{potWidth}{Width of the pot.}

\item{potHeight}{Height of the pot.}

\item{plantMaxHeight}{Max height of plant stem.}

\item{stemColor}{Color of the plant stem and leaves.}

\item{potColor}{Color of the pot.}

\item{flowerColor}{Color of the flowers that bloom when growth is high.}

\item{strokeColor}{Outline color for the pot.}

\item{strokeWidth}{Outline width.}

\item{renderFillLabel}{Whether to display a growth label.}

\item{titleText}{Title shown below the pot.}

\item{titleColor}{Title color.}

\item{titleFontSize}{Font size of the title.}

\item{font}{Font family.}
}
\description{
This function creates a plant growth meter visualization.
}
