`ddst.norm.test` <-
function(x, base = ddst.base.legendre, c = 100, B=1000, compute.p = F, Dmax = 5, ...) {

# method.name = as.character(substitute(base)) 
 # only Legendre is implemented yet
 base = ddst.base.legendre
 method.name = "ddst.base.legendre"

n = length(x)
if(n<5) 
	stop("length(x) should be at least 5")
er1 = mean(x)
sx  = sort(x)
H   = qnorm((1:n - 3/8)/(n+1/4))
er2 = mean((sx[-1] - sx[-n])/(H[-1] - H[-n]))
pp   = (x-er1)/er2
tmpp = c(mean(pp), (mean(pp^2) - 1)/2)

maxN = max(min(Dmax, length(x)-2, 20),1)
u = numeric(maxN)
for (j in 1:maxN) 
u[j] = ddst.phi(pnorm(x,er1,er2), j, base)

coord = numeric(Dmax)
for (k in 1:Dmax) {
  korekta = u[1:k] - t(MMnorm12[[k]]) %*% tmpp
  coord[k] = t(korekta) %*% MMnorm[[k]] %*% korekta * n
}

l = ddst.IIC(coord, n, c)
attr(l, "names") = "n. coord"
t = coord[l]
attr(t, "names") = "WT*"
result = list(statistic = t, parameter = l, method = "Data Driven Smooth Test for Normality")
result$data.name = paste(paste(as.character(substitute(x)), collapse=""), ",   base: ", method.name, ",   c: ", c, sep="")
class(result) = "htest"
if (compute.p) {
  ns <- as.numeric(rownames(tabNorm))
  ts <- as.numeric(colnames(tabNorm))
  n1 <- min(nrow(tabNorm), nrow(tabNorm) + 1 - sum(ns >= n))
  n2 <- max(1, sum(ns <= n))
  
  t1 <- min(ncol(tabNorm), ncol(tabNorm) + 1 - sum(ts >= t))
  t2 <- max(1, sum(ts <= t))
  
  del1 <- (t - ts[t1])/min(diff(ts[c(t1,t2)]),-10^-6)
  del2 <- (n - ns[n1])/min(diff(ns[c(n1,n2)]),-10^-6)
  
  tmpwt <- tabNorm[n1,t1] + del2 * diff(tabNorm[c(n1,n2),t1]) + del1 * diff(tabNorm[n1,c(t1,t2)])
  
  p.val =10^(-tmpwt*(t^0.71*log(n)))
# tmp = numeric(B)
# for (i in 1:B) {
# y = rnorm(n)
# tmpC = ddst.norm.Nk(y, base, Dmax = Dmax, n=length(y))
# l = ddst.IIC(tmpC, n, c)
# tmp[i] = tmpC[l]
# }
# p.val = mean(tmp > t)
 result$p.value = p.val  
}
result
}


#
# data
#


`MMnorm` <-
list(structure(22.1875398382093, .Dim = c(1L, 1L)), structure(c(22.1875398382093, 
2.01931363023228e-08, 2.01931363023228e-08, 4.16508527502846), .Dim = c(2L, 
2L)), structure(c(83.4756259149887, 7.8604632343874e-08, 15.4458059238418, 
7.8604632343874e-08, 4.16508527502846, 1.47208485259075e-08, 
15.4458059238418, 1.47208485259075e-08, 3.89264759121555), .Dim = c(3L, 
3L)), structure(c(83.4756259149887, -3.11486631106693e-07, 15.4458059238418, 
-2.91564738982522e-07, -3.11486631106693e-07, 8.28540092728336, 
-5.83343698116557e-08, 3.0796351270439, 15.4458059238418, -5.83343698116557e-08, 
3.89264759121555, -5.46034419676308e-08, -2.91564738982522e-07, 
3.0796351270439, -5.46034419676308e-08, 2.30180241422338), .Dim = c(4L, 
4L)), structure(c(195.740517005162, -2.07574657321328e-06, 36.4704626100170, 
-1.25498828263742e-06, 16.28123440358, -2.07574657321328e-06, 
8.2854009272834, -3.88740066799939e-07, 3.07963512704392, -2.55862089985123e-07, 
36.4704626100170, -3.88740066799939e-07, 7.83008684296238, -2.35030724727411e-07, 
3.04910431425500, -1.25498828263742e-06, 3.07963512704392, -2.35030724727411e-07, 
2.30180241422338, -1.39720658808408e-07, 16.28123440358, -2.55862089985123e-07, 
3.04910431425500, -1.39720658808408e-07, 2.36118871296460), .Dim = c(5L, 
5L)), structure(c(195.74051700562, -5.3817963869213e-05, 36.4704626101029, 
-2.31271064442009e-05, 16.2812344036189, -2.87527480450007e-05, 
-5.3817963869213e-05, 14.1151813391882, -1.00788786846730e-05, 
5.54396025048634, -4.64763013466494e-06, 3.23956366968714, 36.4704626101029, 
-1.00788786846730e-05, 7.83008684297847, -4.33118021209071e-06, 
3.04910431426229, -5.38473472458586e-06, -2.31271064442009e-05, 
5.54396025048634, -4.33118021209071e-06, 3.34350516886373, -1.99617897527181e-06, 
1.36940631998744, 16.2812344036189, -4.64763013466494e-06, 3.04910431426229, 
-1.99617897527181e-06, 2.36118871296791, -2.44047137250392e-06, 
-2.87527480450007e-05, 3.23956366968714, -5.38473472458586e-06, 
1.36940631998744, -2.44047137250391e-06, 1.80020035549295), .Dim = c(6L, 
6L)), structure(c(364.715151396685, -8.36073153539962e-05, 68.1155623580781, 
-3.60470490628969e-05, 30.4083183463369, -4.95248263314955e-05, 
17.7649215866143, -8.36073153539962e-05, 14.1151813391934, -1.56577456108281e-05, 
5.54396025048862, -7.1381617493137e-06, 3.23956366969081, -3.13186351993226e-06, 
68.1155623580781, -1.56577456108281e-05, 13.7564931445402, -6.75079114588642e-06, 
5.69478531914434, -9.27487179585528e-06, 3.32696512496847, -3.60470490628969e-05, 
5.54396025048861, -6.75079114588642e-06, 3.34350516886471, -3.07634769152424e-06, 
1.36940631998903, -1.35832084118318e-06, 30.4083183463369, -7.1381617493137e-06, 
5.69478531914434, -3.07634769152424e-06, 3.54228019124693, -4.17711601550329e-06, 
1.48523202547124, -4.95248263314955e-05, 3.23956366969081, -9.27487179585528e-06, 
1.36940631998903, -4.17711601550329e-06, 1.80020035549551, -2.18384459466602e-06, 
17.7649215866143, -3.13186351993226e-06, 3.32696512496847, -1.35832084118318e-06, 
1.48523202547124, -2.18384459466602e-06, 1.86769120771211), .Dim = c(7L, 
7L)), structure(c(364.715151404168, 0.000153673123723023, 68.1155623594796, 
6.42545242390361e-05, 30.4083183469599, 9.08550242207575e-06, 
17.7649215869971, 0.000108489210505120, 0.000153673123723023, 
21.6451868798598, 2.8779475315759e-05, 8.72699297597999, 1.26145290270224e-05, 
5.09954042113057, 9.00406362783467e-06, 3.44286431441111, 68.1155623594796, 
2.8779475315759e-05, 13.7564931448027, 1.20334086366145e-05, 
5.69478531926101, 1.70150762055735e-06, 3.32696512504015, 2.03175577140692e-05, 
6.42545242390361e-05, 8.72699297597999, 1.20334086366145e-05, 
4.68901511262663, 5.2733754020427e-06, 2.15564304139812, 3.77169573807455e-06, 
1.45534418573975, 30.4083183469599, 1.26145290270224e-05, 5.69478531926101, 
5.2733754020427e-06, 3.54228019129879, 7.01970118490705e-07, 
1.48523202550310, 9.0313126358506e-06, 9.08550242207575e-06, 
5.09954042113057, 1.70150762055735e-06, 2.15564304139812, 7.01970118490705e-07, 
2.25963076324395, 8.13834786857419e-07, 0.850417379985028, 17.7649215869971, 
9.00406362783467e-06, 3.32696512504015, 3.77169573807455e-06, 
1.48523202550310, 8.13834786857419e-07, 1.86769120773168, 5.54878084401015e-06, 
0.000108489210505120, 3.44286431441111, 2.03175577140692e-05, 
1.45534418573975, 9.0313126358506e-06, 0.850417379985028, 5.54878084401015e-06, 
1.57414421854416), .Dim = c(8L, 8L)), structure(c(594.280145860191, 
0.00332096015316808, 111.107856287996, 0.00140266349755414, 49.6010448687294, 
0.00077320915692121, 28.9775535325382, 0.000688977032408123, 
19.3509389865028, 0.00332096015316808, 21.6451869235586, 0.0006219401845456, 
8.72699299444589, 0.000277414804505137, 5.09954043167311, 0.000163703711155572, 
3.44286432242005, 0.000266983118243996, 111.107856287996, 0.0006219401845456, 
21.8079704251945, 0.000262686920134203, 9.28914578292315, 0.000144804461229855, 
5.42683566260733, 0.000129029703136393, 3.62399005419742, 0.00140266349755414, 
8.72699299444589, 0.000262686920134203, 4.68901512042982, 0.000117170737889685, 
2.15564304585311, 6.9143540630858e-05, 1.45534418912411, 0.000112819772208653, 
49.6010448687294, 0.000277414804505137, 9.28914578292315, 0.000117170737889685, 
5.14688350728912, 6.45863457149036e-05, 2.42266144077597, 5.75628583159839e-05, 
1.61783063130970, 0.00077320915692121, 5.09954043167311, 0.000144804461229855, 
2.15564304585311, 6.45863457149036e-05, 2.25963076578739, 3.81358895673912e-05, 
0.850417381917223, 6.44109972053659e-05, 28.9775535325382, 0.000163703711155572, 
5.42683566260733, 6.9143540630858e-05, 2.42266144077597, 3.81358895673912e-05, 
2.41534924873259, 3.39015195152107e-05, 0.945156979052586, 0.000688977032408123, 
3.44286432242005, 0.000129029703136393, 1.45534418912411, 5.75628583159839e-05, 
0.850417381917223, 3.39015195152107e-05, 1.57414422001201, 4.89316084565545e-05, 
19.3509389865028, 0.000266983118243996, 3.62399005419742, 0.000112819772208653, 
1.61783063130970, 6.44109972053659e-05, 0.945156979052586, 4.89316084565545e-05, 
1.63116698408955), .Dim = c(9L, 9L)), structure(c(594.281908667211, 
0.130779031350136, 111.108186421594, 0.0552808724220031, 49.601192246349, 
0.0322564593189654, 28.977639642486, 0.0219443357631424, 19.3509974632924, 
0.0504946081258542, 0.130779031350136, 30.8609206348895, 0.0244919334012417, 
12.6226052662169, 0.0109334122679083, 7.37590666831766, 0.0063898009143201, 
4.97971266918774, 0.00449509132352050, 3.65096425809516, 111.108186421594, 
0.0244919334012417, 21.8080322516969, 0.0103528480960937, 9.28917338339402, 
0.00604090002230419, 5.42685178903895, 0.00410967419238971, 3.62400100556801, 
0.00945648982543631, 0.0552808724220031, 12.6226052662169, 0.0103528480960937, 
6.33574184315555, 0.00462160150669055, 3.11789309824064, 0.00270099700228912, 
2.10499026908388, 0.00190009691440726, 1.54331077840778, 49.601192246349, 
0.0109334122679083, 9.28917338339402, 0.00462160150669055, 5.1468958286394, 
0.00269671023332643, 2.42266863990723, 0.00183459468212579, 1.61783552019996, 
0.00422154839667336, 0.0322564593189654, 7.37590666831766, 0.00604090002230419, 
3.11789309824064, 0.00269671023332643, 2.82191298938985, 0.00157603595301269, 
1.23003226631038, 0.00110879043186041, 0.901819869003527, 28.977639642486, 
0.00638980091432011, 5.42685178903895, 0.00270099700228912, 2.42266863990723, 
0.00157603595301269, 2.41535345504844, 0.00107218750880477, 0.945159835538435, 
0.00246657065711778, 0.0219443357631424, 4.97971266918774, 0.00410967419238971, 
2.10499026908388, 0.00183459468212579, 1.23003226631038, 0.00107218750880477, 
1.83043448565397, 0.000754025886218155, 0.608847711958374, 19.3509974632924, 
0.00449509132352050, 3.62400100556801, 0.00190009691440726, 1.61783552019996, 
0.00110879043186041, 0.945159835538435, 0.000754025886218155, 
1.6311689239133, 0.00167503450298739, 0.0504946081258542, 3.65096425809516, 
0.00945648982543631, 1.54331077840778, 0.00422154839667336, 0.901819869003527, 
0.00246657065711777, 0.608847711958374, 0.00167503450298739, 
1.44638944997938), .Dim = c(10L, 10L)), structure(c(875.35991599822, 
0.234753309658509, 163.747694185620, 0.0992316272241327, 73.1006519026939, 
0.0579166958257177, 42.7063191971557, 0.0393474894274913, 28.5188819360194, 
0.0795543625397017, 20.3529811872338, 0.234753309658509, 30.8609590962783, 
0.0439639471750806, 12.6226215241520, 0.0196261569675241, 7.37591616036079, 
0.0114682115746842, 4.97971910683243, 0.00788640671214772, 3.65097500766259, 
0.00752882287184567, 163.747694185620, 0.0439639471750806, 31.6662129181615, 
0.0185838232641971, 13.6900868549836, 0.0108464777750782, 7.99792072776532, 
0.00736888842665815, 5.34093692120329, 0.0148987198405616, 3.8116497316874, 
0.0992316272241327, 12.6226215241520, 0.0185838232641971, 6.3357487155141, 
0.00829609386255197, 3.11789711060281, 0.00484768159918726, 2.10499299032752, 
0.00333363291511101, 1.54331532233547, 0.00318249333751333, 73.1006519026939, 
0.0196261569675241, 13.6900868549836, 0.00829609386255197, 7.11156253943566, 
0.00484202817651426, 3.570451614439, 0.00328958118680428, 2.38431431143163, 
0.006651082222375, 1.70160613004667, 0.0579166958257177, 7.37591616036079, 
0.0108464777750781, 3.11789711060281, 0.00484202817651426, 2.82191533196991, 
0.00282935764702690, 1.23003385508298, 0.00194574699801294, 0.901822521933145, 
0.00185806892485493, 42.7063191971557, 0.0114682115746842, 7.99792072776532, 
0.00484768159918726, 3.570451614439, 0.00282935764702690, 3.0859026883538, 
0.00192220890381615, 1.39294637463994, 0.00388593484029732, 0.9940996784309, 
0.0393474894274913, 4.97971910683243, 0.00736888842665815, 2.10499299032752, 
0.00328958118680428, 1.23003385508298, 0.00192220890381615, 1.83043556318316, 
0.00132166226506858, 0.608849511214659, 0.00126016995243566, 
28.5188819360194, 0.00788640671214772, 5.34093692120329, 0.00333363291511102, 
2.38431431143163, 0.00194574699801294, 1.39294637463994, 0.00132166226506858, 
1.93019660844604, 0.00262287269851804, 0.66385051599005, 0.0795543625397017, 
3.65097500766259, 0.0148987198405616, 1.54331532233547, 0.006651082222375, 
0.901822521933145, 0.00388593484029732, 0.608849511214659, 0.00262287269851804, 
1.44639245437426, 0.00210422950022608, 20.3529811872338, 0.00752882287184567, 
3.8116497316874, 0.00318249333751333, 1.70160613004667, 0.00185806892485493, 
0.9940996784309, 0.00126016995243566, 0.66385051599005, 0.00210422950022608, 
1.47376825081888), .Dim = c(11L, 11L)), structure(c(877.834413401248, 
5.45319119108603, 164.211111179698, 2.30513418953969, 73.3075316079886, 
1.3469159677134, 42.8271813330919, 0.909593193760506, 28.5996323910902, 
0.717732540808027, 20.4109422071954, 1.84207308924979, 5.45319119108603, 
41.8660601276342, 1.02125848538486, 17.2746229688772, 0.455912285086717, 
10.0942712579571, 0.266352919809908, 6.81496983049696, 0.178180072475712, 
4.99682131022092, 0.129762122386862, 3.88472583461895, 164.211111179698, 
1.02125848538486, 31.7530003644273, 0.431699122316912, 13.7288307110272, 
0.252246677757455, 8.02055545256433, 0.170346084489884, 5.35605964192773, 
0.134414954813103, 3.82250451036343, 0.344978326850289, 2.30513418953968, 
17.2746229688772, 0.431699122316912, 8.30221112054473, 0.192719998063092, 
4.26698168558885, 0.112590811586839, 2.88077769176687, 0.0753190128677788, 
2.11222231610507, 0.0548521222048209, 1.64212487859206, 73.3075316079886, 
0.455912285086717, 13.7288307110272, 0.192719998063092, 7.12885866284659, 
0.112608473664316, 3.58055626156175, 0.0760462446716918, 2.39106543201354, 
0.0600058011580506, 1.70645194589338, 0.154006036688034, 1.3469159677134, 
10.0942712579571, 0.252246677757455, 4.26698168558885, 0.112608473664316, 
3.49337254218303, 0.0657880841463511, 1.68335665019649, 0.0440097546884277, 
1.2342581939653, 0.0320507506536225, 0.959560865930497, 42.8271813330919, 
0.266352919809908, 8.02055545256433, 0.112590811586839, 3.58055626156175, 
0.0657880841463511, 3.09180597032337, 0.0444277110256887, 1.39689047757807, 
0.0350565384703461, 0.99693067460209, 0.0899725689123183, 0.909593193760506, 
6.81496983049696, 0.170346084489884, 2.88077769176687, 0.0760462446716918, 
1.68335665019649, 0.0444277110256887, 2.13648865702706, 0.0297204541014723, 
0.833287741602, 0.0216442400987866, 0.647831026622058, 28.5996323910902, 
0.178180072475712, 5.35605964192773, 0.0753190128677788, 2.39106543201354, 
0.0440097546884277, 1.39689047757807, 0.0297204541014723, 1.93283174396332, 
0.023448587952198, 0.665741962201525, 0.0601125060986542, 0.717732540808027, 
4.99682131022092, 0.134414954813103, 2.11222231610507, 0.0600058011580506, 
1.2342581939653, 0.0350565384703461, 0.833287741602, 0.023448587952198, 
1.61097997292126, 0.0170525006458588, 0.475074593688724, 20.4109422071954, 
0.129762122386862, 3.82250451036343, 0.0548521222048209, 1.70645194589338, 
0.0320507506536225, 0.99693067460209, 0.0216442400987866, 0.665741962201525, 
0.0170525006458588, 1.47512589210428, 0.0431475236005352, 1.84207308924979, 
3.88472583461895, 0.344978326850289, 1.64212487859206, 0.154006036688034, 
0.959560865930497, 0.0899725689123183, 0.647831026622058, 0.0601125060986542, 
0.475074593688724, 0.0431475236005352, 1.37128180533356), .Dim = c(12L, 
12L)), structure(c(1061.50544103609, 5.09667270095804, 198.608510595672, 
2.15442876223365, 88.6633040011293, 1.25883822450216, 51.7982164459463, 
0.850180754791712, 34.5904029299509, 0.684824852505641, 24.6863308324111, 
2.08575939352690, 14.9063651839370, 5.09667270095804, 41.866752155307, 
0.954490693741131, 17.2749154987993, 0.426105641878756, 10.0944422231029, 
0.248939504452541, 6.8150851542544, 0.166551562009358, 4.99688518637766, 
0.121463289865477, 3.88425282222074, -0.0289343119440951, 198.608510595672, 
0.954490693741131, 38.1948496959092, 0.403475428880041, 16.604617072923, 
0.235751722881294, 9.70062596736035, 0.159219488097394, 6.47799449299377, 
0.128252094437301, 4.6231874057215, 0.390615220422242, 2.79162262919136, 
2.15442876223365, 17.2749154987993, 0.403475428880041, 8.30233477709588, 
0.180120306811169, 4.26705395498321, 0.105229913695267, 2.8808264407564, 
0.0704034764025158, 2.11224931746338, 0.0513440878786698, 1.64192492953593, 
-0.0122309444421119, 88.6633040011293, 0.426105641878756, 16.604617072923, 
0.180120306811169, 8.41267434584443, 0.105244754981681, 4.33057750932076, 
0.0710790819031579, 2.89192237193968, 0.0572545617379692, 2.06389479067104, 
0.174379371949404, 1.24624310061926, 1.25883822450216, 10.0944422231029, 
0.235751722881294, 4.26705395498321, 0.105244754981681, 3.49341477905049, 
0.0614861071977606, 1.68338514088232, 0.0411369360628996, 1.23427397454299, 
0.0300005275655878, 0.959444008416233, -0.00714820961036598, 
51.7982164459463, 0.248939504452541, 9.70062596736035, 0.105229913695267, 
4.33057750932076, 0.0614861071977606, 3.52997780413087, 0.0415258321447744, 
1.68949739304663, 0.0334492298433672, 1.20575327428918, 0.101874927277394, 
0.728070873191761, 0.850180754791712, 6.8150851542544, 0.159219488097394, 
2.8808264407564, 0.0710790819031579, 1.68338514088232, 0.0415258321447744, 
2.13650787528892, 0.0277826074328964, 0.833298386318527, 0.0202612714889060, 
0.647752200920114, -0.00482179210919886, 34.5904029299509, 0.166551562009358, 
6.47799449299377, 0.0704034764025158, 2.89192237193968, 0.0411369360628996, 
1.68949739304663, 0.0277826074328964, 2.12823181392227, 0.0223752427865365, 
0.805191675898576, 0.0680607859726555, 0.486198691951386, 0.684824852505641, 
4.99688518637766, 0.128252094437301, 2.11224931746338, 0.0572545617379692, 
1.23427397454299, 0.0334492298433672, 0.833298386318527, 0.0223752427865365, 
1.61098586887537, 0.0162864943896632, 0.475030933275605, -0.00267072072014777, 
24.6863308324111, 0.121463289865477, 4.6231874057215, 0.0513440878786698, 
2.06389479067104, 0.0300005275655878, 1.20575327428918, 0.0202612714889060, 
0.805191675898576, 0.0162864943896632, 1.57464593144856, 0.0488199133445428, 
0.346981802036942, 2.08575939352690, 3.88425282222074, 0.390615220422242, 
1.64192492953593, 0.174379371949404, 0.959444008416233, 0.101874927277395, 
0.647752200920114, 0.0680607859726555, 0.475030933275605, 0.0488199133445428, 
1.37160511715719, 0.0197770823665226, 14.9063651839370, -0.0289343119440951, 
2.79162262919136, -0.0122309444421119, 1.24624310061926, -0.00714820961036598, 
0.728070873191761, -0.00482179210919886, 0.486198691951386, -0.00267072072014777, 
0.346981802036942, 0.0197770823665226, 1.20977013009747), .Dim = c(13L, 
13L)), structure(c(1210.17118296149, -46.793651866521, 226.450217425161, 
-19.7802965859688, 101.092468427073, -11.5585343081507, 59.0594863384723, 
-7.8031992566023, 39.4390147077578, -5.65091883154274, 28.1433192177335, 
-2.61185452827675, 17.1255344465684, -15.4032858122985, -46.7936518665209, 
59.9785629117373, -8.76338502654226, 24.9310170516869, -3.91217275240275, 
14.568220863747, -2.28553579977935, 9.83546289280627, -1.52580900198900, 
7.20831461109647, -1.08516472689981, 5.52390906001967, -0.803513658986248, 
5.37636640327361, 226.450217425161, -8.76338502654228, 43.4089671458336, 
-3.70439895173182, 18.9323164312344, -2.1646501703641, 11.0604964051573, 
-1.46136146243716, 7.38602902670259, -1.05828836817025, 5.27060257945662, 
-0.489140854616294, 3.20722247899536, -2.88468454293951, -19.7802965859687, 
24.9310170516869, -3.70439895173181, 11.5386699937344, -1.65372725255145, 
6.15817925761204, -0.966126262306948, 4.15757999154227, -0.644979679722469, 
3.04704973473695, -0.458713506977467, 2.33502927107491, -0.339655861888239, 
2.27266106755128, 101.092468427073, -3.91217275240276, 18.9323164312344, 
-1.65372725255145, 9.45181171755088, -0.966348664280038, 4.93765427271289, 
-0.652384720912712, 3.29728942048386, -0.472443800438763, 2.35291549243642, 
-0.218363536319265, 1.43177622544695, -1.28778809146855, -11.5585343081507, 
14.568220863747, -2.16465017036410, 6.15817925761204, -0.966348664280036, 
4.59847796652761, -0.564551876182057, 2.4294453551330, -0.376891202884841, 
1.78051674720924, -0.268047344135518, 1.36445370917514, -0.198476210155586, 
1.32801040728092, 59.0594863384723, -2.28553579977935, 11.0604964051573, 
-0.96612626230695, 4.93765427271289, -0.564551876182058, 3.88463947513347, 
-0.38113057094809, 1.92631778129992, -0.276007032668192, 1.37460270359314, 
-0.127570283807083, 0.836461594177436, -0.752341555399767, -7.80319925660228, 
9.83546289280627, -1.46136146243716, 4.15757999154227, -0.65238472091271, 
2.4294453551330, -0.381130570948089, 2.6401947681249, -0.254440315600294, 
1.20208272790778, -0.180959492661191, 0.921185998684778, -0.133992875443180, 
0.896578349736816, 39.4390147077578, -1.52580900198901, 7.38602902670259, 
-0.64497967972247, 3.29728942048386, -0.376891202884842, 1.92631778129992, 
-0.254440315600295, 2.28636532785372, -0.184259863928621, 0.91793852923367, 
-0.0851480561846492, 0.558575085358423, -0.502365588999743, -5.65091883154273, 
7.20831461109647, -1.05828836817025, 3.04704973473695, -0.472443800438761, 
1.78051674720924, -0.276007032668192, 1.20208272790778, -0.184259863928621, 
1.88099863382080, -0.131041276248482, 0.675230907726253, -0.097245889534804, 
0.656447608809503, 28.1433192177335, -1.08516472689981, 5.27060257945662, 
-0.458713506977468, 2.35291549243642, -0.268047344135519, 1.37460270359314, 
-0.180959492661192, 0.91793852923367, -0.131041276248483, 1.65503276799528, 
-0.0604157219543622, 0.398585098577384, -0.358179224475518, -2.61185452827674, 
5.52390906001967, -0.489140854616292, 2.33502927107491, -0.218363536319264, 
1.36445370917514, -0.127570283807083, 0.921185998684778, -0.0851480561846489, 
0.675230907726253, -0.0604157219543619, 1.52004265409416, -0.0503453297504995, 
0.486720672403804, 17.1255344465684, -0.80351365898625, 3.20722247899536, 
-0.33965586188824, 1.43177622544695, -0.198476210155586, 0.836461594177436, 
-0.133992875443181, 0.558575085358423, -0.0972458895348043, 0.398585098577384, 
-0.0503453297504996, 1.24289620307452, -0.229928549613878, -15.4032858122985, 
5.37636640327361, -2.88468454293951, 2.27266106755128, -1.28778809146855, 
1.32801040728092, -0.752341555399767, 0.896578349736816, -0.502365588999743, 
0.656447608809504, -0.358179224475518, 0.486720672403804, -0.229928549613878, 
1.59593737428970), .Dim = c(14L, 14L)), structure(c(-15.3905100998915, 
-8.53933545693131, -3.06956916285352, -3.60968977078394, -1.37032458496202, 
-2.10928870362996, -0.80056151349288, -1.42405348886683, -0.534672697111443, 
-1.0450183104392, -0.382121412625912, -0.834791313602698, -0.209549624167613, 
-0.558290969095932, -4.25261889942709, -8.53933545693131, 58.7845041122088, 
-1.59922300343991, 24.4262725633878, -0.71392975387884, 14.2732749354973, 
-0.417082156207805, 9.63634614331626, -0.278082270073839, 7.0645474087737, 
-0.194780148322681, 5.46844033993902, -0.262421525654076, 4.91299917088887, 
0.132739975367311, -3.06956916285352, -1.59922300343991, 0.425139621151657, 
-0.676012664666284, -0.256630578515510, -0.395021724202551, -0.149926934537647, 
-0.266692778262524, -0.100132016225893, -0.195708123834597, -0.0715626357882717, 
-0.156337396337045, -0.0392438710273392, -0.104555180539991, 
-0.796418644416439, -3.60968977078394, 24.4262725633878, -0.676012664666284, 
11.3253078053992, -0.301787526984080, 6.03350170262977, -0.176306130662386, 
4.07341070115826, -0.117549044743516, 2.98627743189956, -0.0823361387266675, 
2.3115819075575, -0.11092904201202, 2.07678959397149, 0.0561109477774911, 
-1.37032458496202, -0.71392975387884, -0.256630578515510, -0.301787526984080, 
0.88543434849147, -0.176346739466776, -0.0669307493805087, -0.119057760635126, 
-0.044701179974453, -0.0873685860291195, -0.0319471672185456, 
-0.0697925901438693, -0.0175193433050449, -0.0466758386171483, 
-0.355539188698551, -2.10928870362996, 14.2732749354973, -0.395021724202551, 
6.03350170262977, -0.176346739466776, 4.5256230111222, -0.103022850549195, 
2.38026128268063, -0.0686886928476514, 1.74500463427334, -0.0481123575742669, 
1.35075231261119, -0.0648203788034916, 1.21355349901964, 0.0327882640838232, 
-0.80056151349288, -0.417082156207805, -0.149926934537647, -0.176306130662386, 
-0.0669307493805087, -0.103022850549195, 0.960898182364387, -0.0695542765247132, 
-0.0261150129218246, -0.0510412662317897, -0.0186639518506792, 
-0.0407732749999323, -0.0102350412241116, -0.0272682223254019, 
-0.207710450038623, -1.42405348886683, 9.63634614331625, -0.266692778262524, 
4.07341070115826, -0.119057760635126, 2.38026128268063, -0.0695542765247132, 
2.60699080870253, -0.0463741037782018, 1.17810865056662, -0.0324823128503568, 
0.911936243777238, -0.0437623886310936, 0.819308974753726, 0.0221352184942305, 
-0.534672697111443, -0.278082270073839, -0.100132016225893, -0.117549044743516, 
-0.044701179974453, -0.0686886928476514, -0.0261150129218246, 
-0.0463741037782018, 0.982558515198897, -0.034030929154551, -0.0124650998123887, 
-0.0271862499008468, -0.0068368687715961, -0.0181719439562426, 
-0.138706080240730, -1.0450183104392, 7.0645474087737, -0.195708123834597, 
2.98627743189956, -0.0873685860291195, 1.74500463427334, -0.0510412662317897, 
1.17810865056662, -0.034030929154551, 1.86368875890352, -0.0238370917444065, 
0.66855235663181, -0.0320972534385406, 0.600657215007874, 0.0159821734930364, 
-0.382121412625912, -0.194780148322681, -0.0715626357882717, 
-0.0823361387266675, -0.0319471672185456, -0.0481123575742669, 
-0.0186639518506792, -0.0324823128503568, -0.0124650998123887, 
-0.0238370917444065, 0.991091680604096, -0.0190538619080060, 
-0.00489594548728392, -0.0126560072803187, -0.0989814128704786, 
-0.834791313602699, 5.46844033993902, -0.156337396337045, 2.3115819075575, 
-0.0697925901438693, 1.35075231261119, -0.0407732749999323, 0.911936243777238, 
-0.0271862499008468, 0.66855235663181, -0.0190538619080060, 1.51746591423126, 
-0.0252094753909882, 0.465195444904252, 0.00616629310053129, 
-0.209549624167613, -0.262421525654076, -0.0392438710273392, 
-0.11092904201202, -0.0175193433050449, -0.0648203788034916, 
-0.0102350412241116, -0.0437623886310936, -0.0068368687715961, 
-0.0320972534385406, -0.00489594548728392, -0.0252094753909882, 
0.997698314269071, -0.0199519853221691, -0.0601516076748633, 
-0.558290969095932, 4.91299917088887, -0.104555180539991, 2.07678959397149, 
-0.0466758386171483, 1.21355349901964, -0.0272682223254019, 0.819308974753726, 
-0.0181719439562426, 0.600657215007874, -0.0126560072803187, 
0.465195444904252, -0.0199519853221691, 1.4161227854833, 0.0515111609554356, 
-4.25261889942709, 0.132739975367311, -0.796418644416439, 0.0561109477774911, 
-0.355539188698551, 0.0327882640838232, -0.207710450038623, 0.0221352184942305, 
-0.138706080240730, 0.0159821734930363, -0.0989814128704787, 
0.00616629310053130, -0.0601516076748633, 0.0515111609554356, 
-0.0147563093772849), .Dim = c(15L, 15L)), structure(c(7.27112688301585, 
-20.4108591836006, 1.17443920775691, -8.62793957819648, 0.524296295602882, 
-5.04165994332914, 0.306298866490318, -3.40378557104742, 0.204387641675159, 
-2.49517662288600, 0.1445654917659, -1.92666533686050, 0.138481630862867, 
-1.76631788579827, 0.73361165710028, 0.581664973194929, -20.4108591836006, 
65.0035197861064, -3.82248896193559, 27.0551325923429, -1.70644572938555, 
15.8094267489674, -0.996921965352734, 10.6734484675563, -0.665246372736105, 
7.82422725125925, -0.470690316980373, 6.04042939719099, -0.444741157057278, 
5.54583607560606, -2.47934645082975, -0.304710976328157, 1.17443920775691, 
-3.82248896193559, 1.21994570967018, -1.6158165369345, 0.0981887525996934, 
-0.944188057438198, 0.0573628001487239, -0.637451498591409, 0.0382771492974224, 
-0.467289740880909, 0.0270738233790735, -0.360820527800731, 0.0259344548234137, 
-0.330791102961411, 0.137388751565451, 0.108932599043578, -8.62793957819647, 
27.0551325923429, -1.6158165369345, 12.4365616459136, -0.721337133051188, 
6.68285335449775, -0.421412073047429, 4.51180754546501, -0.281208422288902, 
3.30740413063025, -0.198967009591135, 2.55336923347157, -0.187997957194430, 
2.34429810832389, -1.04805246940552, -0.128805352495747, 0.524296295602882, 
-1.70644572938555, 0.0981887525996934, -0.721337133051188, 1.04383368582884, 
-0.421506953819009, 0.0256080548271442, -0.284572800155558, 0.0170877874738652, 
-0.208608733903643, 0.0120863687229871, -0.161078463488807, 0.0115777286923267, 
-0.147672647558841, 0.0613334553576995, 0.0486299645757961, -5.04165994332913, 
15.8094267489674, -0.944188057438197, 6.68285335449775, -0.421506953819008, 
4.90506608021298, -0.246248406014289, 2.63643471906897, -0.164321646614177, 
1.93265226677391, -0.116264606766575, 1.49203866300110, -0.109854938466483, 
1.36986980529497, -0.6124201597162, -0.0752663031282199, 0.306298866490318, 
-0.996921965352735, 0.0573628001487239, -0.421412073047429, 0.0256080548271442, 
-0.246248406014289, 1.01496046840756, -0.166250159809761, 0.0099828474417871, 
-0.121871223571647, 0.00706097117968277, -0.094103583714544, 
0.00676381933832795, -0.0862717767932281, 0.0358315788379531, 
0.0284102121015821, -3.40378557104742, 10.6734484675563, -0.637451498591408, 
4.51180754546501, -0.284572800155558, 2.63643471906897, -0.166250159809761, 
2.77994120589456, -0.110938789218476, 1.30479521507021, -0.0784939475206728, 
1.00732291135, -0.074166575305918, 0.924842817915068, -0.413464407841322, 
-0.0508145466006388, 0.204387641675159, -0.665246372736105, 0.0382771492974224, 
-0.281208422288902, 0.0170877874738652, -0.164321646614177, 0.0099828474417871, 
-0.110938789218476, 1.00666137170390, -0.0813247100274645, 0.00471165587776179, 
-0.0627953626118947, 0.00451341882877272, -0.0575691323850735, 
0.0239090586018316, 0.0189697466460162, -2.49517662288599, 7.82422725125925, 
-0.467289740880909, 3.30740413063025, -0.208608733903643, 1.93265226677391, 
-0.121871223571647, 1.30479521507021, -0.0813247100274645, 1.95648695934883, 
-0.0575407201732239, 0.738423310445359, -0.0543683902436362, 
0.677960998324003, -0.303095556627617, -0.0372217724859849, 0.1445654917659, 
-0.470690316980373, 0.0270738233790735, -0.198967009591135, 0.0120863687229871, 
-0.116264606766575, 0.00706097117968277, -0.0784939475206728, 
0.00471165587776179, -0.0575407201732239, 1.00333259221463, -0.0444304818639799, 
0.00319276868997778, -0.0407321766082377, 0.0169052875643606, 
0.0135186758289462, -1.92666533686050, 6.04042939719099, -0.360820527800731, 
2.55336923347157, -0.161078463488807, 1.49203866300110, -0.094103583714544, 
1.00732291135, -0.0627953626118946, 0.738423310445359, -0.0444304818639798, 
1.57007415623798, -0.0419781795643104, 0.523400119647671, -0.234078293941124, 
-0.0280255515058118, 0.138481630862867, -0.444741157057278, 0.0259344548234137, 
-0.187997957194430, 0.0115777286923267, -0.109854938466483, 0.00676381933832795, 
-0.074166575305918, 0.00451341882877272, -0.0543683902436362, 
0.00319276868997778, -0.0419781795643104, 1.00304328359187, -0.0385045340302624, 
0.0164255645642143, 0.00893305239956808, -1.76631788579827, 5.54583607560606, 
-0.330791102961411, 2.34429810832389, -0.147672647558841, 1.36986980529497, 
-0.0862717767932281, 0.924842817915069, -0.0575691323850735, 
0.677960998324003, -0.0407321766082377, 0.523400119647671, -0.0385045340302624, 
1.48051923806870, -0.214290498903115, -0.0310068926023482, 0.73361165710028, 
-2.47934645082975, 0.137388751565451, -1.04805246940552, 0.0613334553576995, 
-0.6124201597162, 0.0358315788379531, -0.413464407841322, 0.0239090586018316, 
-0.303095556627617, 0.0169052875643606, -0.234078293941124, 0.0164255645642143, 
-0.214290498903116, 1.08236192535571, 0.127983502038877, 0.581664973194924, 
-0.304710976328152, 0.108932599043577, -0.128805352495746, 0.0486299645757958, 
-0.0752663031282198, 0.0284102121015819, -0.0508145466006382, 
0.0189697466460160, -0.0372217724859842, 0.0135186758289462, 
-0.0280255515058111, 0.008933052399568, -0.0310068926023476, 
0.127983502038877, 0.0149298191166424), .Dim = c(16L, 16L)), 
    structure(c(-2.83637791689103, 8.63060642133794, -0.718466190434141, 
    3.64827125127617, -0.320739556807236, 2.13183503003006, -0.187379395129109, 
    1.43926954927924, -0.125064295543697, 1.05500120744730, -0.0887048667199464, 
    0.812888706135441, -0.0752217434645928, 0.758134314811249, 
    -0.59428356617342, 2.16626825351652, 0.247344978070021, 8.63060642133794, 
    -18.4400937643515, 1.61631597590369, -8.21758422757778, 0.721560007790495, 
    -4.80187264293895, 0.421542882159236, -3.24189676196905, 
    0.281353929972624, -2.37634839941863, 0.199555527738968, 
    -1.83101524592903, 0.169283700516611, -1.70756555087531, 
    1.33603867310514, -4.8576844919435, -0.710685853272216, -0.718466190434141, 
    1.61631597590369, 0.865447649324583, 0.683238097069164, -0.0600672124834815, 
    0.399244137527772, -0.0350918921703533, 0.269542399753077, 
    -0.0234216935675167, 0.197577693031959, -0.0166124008233515, 
    0.152235536903873, -0.014087318985669, 0.141981286724028, 
    -0.111295774054567, 0.405692695891577, 0.0463220798280998, 
    3.64827125127617, -8.21758422757778, 0.683238097069164, -2.47368131840838, 
    0.305012939297559, -2.02981494697377, 0.17819174031148, -1.37039255167816, 
    0.118932019842190, -1.00451383429547, 0.0843547555457257, 
    -0.77399431236244, 0.0715584546153152, -0.721810496828017, 
    0.564761181744838, -2.05340735223761, -0.300416290519779, 
    -0.320739556807236, 0.721560007790495, -0.0600672124834815, 
    0.305012939297559, 0.97318463781997, 0.178231612679434, -0.0156658143307276, 
    0.120329823478332, -0.0104559737320128, 0.0882031507754361, 
    -0.00741615144667112, 0.0679613867784901, -0.00628889780577663, 
    0.0633836575769546, -0.0496849506806288, 0.181110394734064, 
    0.0206792258347171, 2.13183503003006, -4.80187264293895, 
    0.399244137527772, -2.02981494697377, 0.178231612679434, 
    -0.186104406620114, 0.104124767018119, -0.800776763797202, 
    0.0694968736228545, -0.586978772200398, 0.0492919551306132, 
    -0.452276728949872, 0.0418145498865727, -0.421783578013323, 
    0.33001320023524, -1.19989042067104, -0.175545596266973, 
    -0.187379395129109, 0.421542882159236, -0.0350918921703533, 
    0.17819174031148, -0.0156658143307276, 0.104124767018119, 
    0.990847867837951, 0.070297937872266, -0.00610848893381929, 
    0.0515292006096923, -0.00433259304258642, 0.0397037509672233, 
    -0.00367403970094334, 0.0370293938329512, -0.0290264665863281, 
    0.105806583240858, 0.0120810072526533, 1.43926954927924, 
    -3.24189676196905, 0.269542399753077, -1.37039255167816, 
    0.120329823478332, -0.800776763797202, 0.070297937872266, 
    0.459370168546303, 0.0469195470411341, -0.396288015622326, 
    0.033278564731384, -0.30534638715633, 0.0282303309292613, 
    -0.284759492270776, 0.222802394662917, -0.810084137105153, 
    -0.118516427767627, -0.125064295543697, 0.281353929972624, 
    -0.0234216935675167, 0.118932019842190, -0.0104559737320128, 
    0.0694968736228545, -0.00610848893381929, 0.0469195470411341, 
    0.9959229569234, 0.0343925700361094, -0.00289174110500366, 
    0.0264998100789042, -0.00245219652894017, 0.0247148421834940, 
    -0.0193733995707549, 0.0706195485269031, 0.00806215617006432, 
    1.0550012074473, -2.37634839941863, 0.197577693031959, -1.00451383429547, 
    0.0882031507754361, -0.586978772200398, 0.0515292006096923, 
    -0.396288015622326, 0.0343925700361094, 0.709516230519084, 
    0.0243935723712606, -0.223822488194653, 0.0206931602402928, 
    -0.208732049442109, 0.163316705943378, -0.593800626222746, 
    -0.0868778867754345, -0.0887048667199464, 0.199555527738968, 
    -0.0166124008233515, 0.0843547555457258, -0.00741615144667112, 
    0.0492919551306132, -0.00433259304258642, 0.033278564731384, 
    -0.00289174110500365, 0.0243935723712606, 0.997948962800119, 
    0.0187954840249406, -0.00173927573897572, 0.0175294697104453, 
    -0.0137411084450237, 0.050089618170905, 0.00570845652278088, 
    0.812888706135441, -1.83101524592903, 0.152235536903873, 
    -0.77399431236244, 0.0679613867784901, -0.452276728949872, 
    0.0397037509672233, -0.30534638715633, 0.0264998100789042, 
    -0.223822488194653, 0.0187954840249406, 0.827541107471631, 
    0.0159443200763586, -0.160831386489583, 0.125836521793415, 
    -0.457518923914551, -0.0670407729801638, -0.0752217434645928, 
    0.169283700516611, -0.014087318985669, 0.0715584546153152, 
    -0.00628889780577663, 0.0418145498865727, -0.00367403970094334, 
    0.0282303309292613, -0.00245219652894017, 0.0206931602402928, 
    -0.00173927573897572, 0.0159443200763586, 0.998524944683998, 
    0.0148700588369709, -0.0116501767373895, 0.0424363823191544, 
    0.00522962466829618, 0.758134314811249, -1.70756555087531, 
    0.141981286724028, -0.721810496828017, 0.0633836575769545, 
    -0.421783578013323, 0.0370293938329512, -0.284759492270776, 
    0.024714842183494, -0.208732049442109, 0.0175294697104453, 
    -0.160831386489583, 0.0148700588369709, 0.850011606430383, 
    0.117364848775081, -0.426777690370127, -0.0617769258149979, 
    -0.59428356617342, 1.33603867310514, -0.111295774054567, 
    0.564761181744838, -0.0496849506806288, 0.33001320023524, 
    -0.0290264665863281, 0.222802394662917, -0.0193733995707549, 
    0.163316705943378, -0.0137411084450237, 0.125836521793415, 
    -0.0116501767373895, 0.117364848775081, 0.907906828979265, 
    0.33616417257809, 0.0324954794859897, 2.16626825351652, -4.85768449194351, 
    0.405692695891578, -2.05340735223761, 0.181110394734064, 
    -1.19989042067104, 0.105806583240858, -0.810084137105154, 
    0.0706195485269031, -0.593800626222746, 0.050089618170905, 
    -0.457518923914552, 0.0424363823191544, -0.426777690370127, 
    0.33616417257809, -0.233496237137112, -0.0387774897345975, 
    0.247344978070016, -0.710685853272208, 0.0463220798280992, 
    -0.300416290519776, 0.0206792258347171, -0.175545596266974, 
    0.012081007252653, -0.118516427767627, 0.00806215617006458, 
    -0.0868778867754329, 0.00570845652278064, -0.0670407729801631, 
    0.00522962466829625, -0.0617769258149961, 0.03249547948599, 
    -0.0387774897346018, -0.00605288242633129), .Dim = c(17L, 
    17L)), structure(c(0.593144180509396, 0.822782521974444, 
    -0.0761948267396611, 0.347801032177597, -0.0340150928935100, 
    0.203234459432528, -0.0198719794472781, 0.137210027996827, 
    -0.0132640384018958, 0.100574150944595, -0.00941373019008328, 
    0.0774330752363128, -0.00774961604558476, 0.0726660721896938, 
    -0.0665158283376474, 0.290249540818928, -0.567621685992274, 
    -0.0867303535892785, 0.822782521974444, -0.664405982756252, 
    0.154088423227561, -0.703566377875464, 0.0687885550056585, 
    -0.411122795066118, 0.0401870062275493, -0.277562035457562, 
    0.0268237957803374, -0.203451368777077, 0.0190373058925972, 
    -0.156639665667187, 0.0156732340897141, -0.146993793354898, 
    0.134495880915335, -0.586645167905804, 1.14470857666100, 
    0.197454720606063, -0.0761948267396611, 0.154088423227561, 
    0.985730444683928, 0.0651352103549284, -0.00637025202883776, 
    0.0380611845330820, -0.00372156906310254, 0.0256963125739528, 
    -0.00248405223542343, 0.0188352473741351, -0.00176297721808518, 
    0.0145014510519648, -0.00145132654764906, 0.0136086999745454, 
    -0.0124568994047512, 0.0543571270570831, -0.106302611259207, 
    -0.0162426194937523, 0.347801032177597, -0.703566377875464, 
    0.0651352103549284, 0.702593205500816, 0.0290778301604667, 
    -0.173787032000272, 0.0169875779720358, -0.117329136007568, 
    0.0113387725312086, -0.0860015789941175, 0.00804732047958067, 
    -0.066213654208683, 0.00662528292516647, -0.0621362166636898, 
    0.0568531841120666, -0.247982655769433, 0.483883424689624, 
    0.0834667166396862, -0.0340150928935100, 0.0687885550056585, 
    -0.00637025202883776, 0.0290778301604668, 0.99715617550708, 
    0.0169913730765345, -0.00166139254865125, 0.0114714147494747, 
    -0.00110893706509702, 0.00840848016289622, -0.000787032878848521, 
    0.00647377552742824, -0.000647904975318448, 0.00607523126749094, 
    -0.00556104145822569, 0.0242662501525019, -0.0474558883953214, 
    -0.00725107272432608, 0.203234459432528, -0.411122795066118, 
    0.038061184533082, -0.173787032000272, 0.0169913730765345, 
    0.89844908371269, 0.00992654105883075, -0.0685602437168511, 
    0.00662571152126983, -0.0502542626367787, 0.00470238060338253, 
    -0.0386913636663626, 0.00387142552578668, -0.0363087490718542, 
    0.0332216556918847, -0.144906473344171, 0.282753002980941, 
    0.0487730373707678, -0.0198719794472781, 0.0401870062275493, 
    -0.00372156906310254, 0.0169875779720358, -0.00166139254865125, 
    0.00992654105883076, 0.999029396783245, 0.00670172263304587, 
    -0.000647852840941316, 0.0049123236364343, -0.000459792987832367, 
    0.00378204858952325, -0.000378512985113106, 0.00354921478977273, 
    -0.00324881963309014, 0.0141766017419989, -0.0277242355441185, 
    -0.00423615214549096, 0.137210027996827, -0.277562035457562, 
    0.0256963125739528, -0.117329136007568, 0.0114714147494747, 
    -0.0685602437168511, 0.00670172263304587, 0.953712805454012, 
    0.00447322794505741, -0.0339282462448738, 0.00317472625480171, 
    -0.0261217664959650, 0.00261372213304102, -0.0245131878312595, 
    0.0224289931923058, -0.0978309550004388, 0.190895517784301, 
    0.0329282271604823, -0.0132640384018958, 0.0268237957803374, 
    -0.00248405223542343, 0.0113387725312086, -0.00110893706509702, 
    0.00662571152126983, -0.000647852840941316, 0.00447322794505742, 
    0.999567574786176, 0.00327885001634986, -0.000306900068456936, 
    0.00252442041361111, -0.000252647734352316, 0.00236900984559530, 
    -0.00216850421641039, 0.00946252182589284, -0.0185052430233174, 
    -0.00282735482026217, 0.100574150944595, -0.203451368777077, 
    0.0188352473741351, -0.0860015789941175, 0.00840848016289622, 
    -0.0502542626367787, 0.0049123236364343, -0.0339282462448738, 
    0.00327885001634986, 0.975130791473482, 0.0023270558433995, 
    -0.0191471039714509, 0.00191584312741800, -0.0179680250238730, 
    0.0164403207696235, -0.071709510594367, 0.139925210635233, 
    0.0241368312361620, -0.00941373019008328, 0.0190373058925972, 
    -0.00176297721808518, 0.00804732047958067, -0.000787032878848521, 
    0.00470238060338253, -0.000459792987832367, 0.00317472625480171, 
    -0.000306900068456936, 0.0023270558433995, 0.99978218741674, 
    0.00179162424941028, -0.000179308631256499, 0.00168132688792506, 
    -0.00153902822267621, 0.00671574517739467, -0.013133711917082, 
    -0.00200522058538230, 0.0774330752363128, -0.156639665667187, 
    0.0145014510519647, -0.066213654208683, 0.00647377552742824, 
    -0.0386913636663626, 0.00378204858952325, -0.0261217664959650, 
    0.00252442041361111, -0.0191471039714509, 0.00179162424941028, 
    0.985258413165982, 0.00147502825384288, -0.0138337977524575, 
    0.0126575587850030, -0.0552096555265687, 0.107727548977572, 
    0.0185991881975184, -0.00774961604558476, 0.0156732340897141, 
    -0.00145132654764906, 0.00662528292516648, -0.000647904975318448, 
    0.00387142552578668, -0.000378512985113106, 0.00261372213304103, 
    -0.000252647734352316, 0.00191584312741800, -0.000179308631256499, 
    0.00147502825384288, 0.999852385607006, 0.00138421465975952, 
    -0.00126691894124092, 0.00552774897938895, -0.0108039604896867, 
    -0.00170632563438122, 0.0726660721896938, -0.146993793354898, 
    0.0136086999745454, -0.0621362166636898, 0.00607523126749093, 
    -0.0363087490718542, 0.00354921478977272, -0.0245131878312595, 
    0.00236900984559530, -0.0179680250238730, 0.00168132688792506, 
    -0.0138337977524575, 0.00138421465975952, 0.987018075057263, 
    0.0118784242843735, -0.0518125454909831, 0.101112757104187, 
    0.0173350400925671, -0.0665158283376474, 0.134495880915335, 
    -0.0124568994047512, 0.0568531841120666, -0.00556104145822569, 
    0.0332216556918847, -0.00324881963309015, 0.0224289931923058, 
    -0.00216850421641039, 0.0164403207696235, -0.00153902822267621, 
    0.0126575587850030, -0.00126691894124092, 0.0118784242843735, 
    0.98912478798044, 0.0474644284100960, -0.0929194035467711, 
    -0.0133468982603174, 0.290249540818928, -0.586645167905804, 
    0.0543571270570831, -0.247982655769433, 0.0242662501525019, 
    -0.144906473344171, 0.0141766017419989, -0.0978309550004389, 
    0.00946252182589284, -0.071709510594367, 0.00671574517739467, 
    -0.0552096555265687, 0.00552774897938895, -0.0518125454909831, 
    0.0474644284100959, 0.792724358746857, 0.40702593960176, 
    0.0474432768389973, -0.567621685992275, 1.14470857666100, 
    -0.106302611259207, 0.483883424689625, -0.0474558883953214, 
    0.282753002980942, -0.0277242355441186, 0.190895517784301, 
    -0.0185052430233174, 0.139925210635233, -0.0131337119170820, 
    0.107727548977572, -0.0108039604896868, 0.101112757104187, 
    -0.0929194035467711, 0.407025939601761, 0.187609862605421, 
    0.0206099698236592, -0.0867303535892708, 0.19745472060605, 
    -0.0162426194937510, 0.0834667166396773, -0.00725107272432564, 
    0.0487730373707627, -0.00423615214549062, 0.0329282271604801, 
    -0.00282735482026198, 0.0241368312361619, -0.00200522058538221, 
    0.0185991881975174, -0.00170632563438099, 0.0173350400925655, 
    -0.0133468982603167, 0.0474432768389847, 0.0206099698237116, 
    0.00219335348198413), .Dim = c(18L, 18L)), structure(c(0.817709701811581, 
    0.361676768949925, -0.0341388202439329, 0.152885544115685, 
    -0.0152403409202673, 0.0893373168349527, -0.00890356999024128, 
    0.0603144544544598, -0.00594295862849122, 0.0442099438211003, 
    -0.00421826993173935, 0.0340326397397744, -0.00345502934478953, 
    0.0319751205063959, -0.0300651109735747, 0.134603100039853, 
    -0.299050299976079, 0.270469136346911, 0.053953958811838, 
    0.361676768949925, 0.282393482448392, 0.0677338197605316, 
    -0.303341746873502, 0.0302379079772519, -0.17725506951209, 
    0.0176653088946692, -0.119670516149959, 0.0117912476745855, 
    -0.0877173949301466, 0.00836934314906923, -0.067524513994841, 
    0.00685505655686588, -0.0634420895652346, 0.0596507516141745, 
    -0.267052610398076, 0.59324452967942, -0.535991530768393, 
    -0.110784953372768, -0.0341388202439329, 0.0677338197605316, 
    0.99360657665696, 0.0286319796518541, -0.00285416867657697, 
    0.0167308443225614, -0.00166743583419862, 0.0112955233448759, 
    -0.00111298076941805, 0.00827951536698293, -0.000789985865244395, 
    0.00637353815342267, -0.000647048290070637, 0.00598821167168013, 
    -0.00563051039655367, 0.0252080943539133, -0.0560053087642936, 
    0.050652707900752, 0.0101043474042817, 0.152885544115685, 
    -0.303341746873502, 0.0286319796518541, 0.871773439697543, 
    0.0127819628212345, -0.0749280575257798, 0.00746735923950668, 
    -0.0505863067437534, 0.00498431602827496, -0.0370793006452731, 
    0.00353783181859127, -0.0285435033420056, 0.00289772288854229, 
    -0.0268178086504621, 0.0252151600555397, -0.112886663323073, 
    0.250772293108717, -0.226570694769991, -0.046830262070968, 
    -0.0152403409202673, 0.0302379079772519, -0.00285416867657697, 
    0.0127819628212345, 0.998725834596387, 0.00746902703547407, 
    -0.000744381041707896, 0.00504257690862256, -0.00049685976968249, 
    0.00369616278320324, -0.000352667544528175, 0.00284529147852675, 
    -0.000288856980472801, 0.00267327302840267, -0.00251358709484486, 
    0.0112534630416396, -0.025002035594032, 0.022612513589516, 
    0.00451080908944926, 0.0893373168349527, -0.17725506951209, 
    0.0167308443225614, -0.0749280575257798, 0.00746902703547407, 
    0.95621645163573, 0.00436348539136854, -0.0295596613741502, 
    0.00291254103060652, -0.0216669617059942, 0.00206730076355104, 
    -0.0166791439726083, 0.00169325876616235, -0.0156707495275378, 
    0.0147342559818771, -0.0659643242670458, 0.146536573703041, 
    -0.132394583576290, -0.0273648497100685, -0.00890356999024128, 
    0.0176653088946692, -0.00166743583419862, 0.00746735923950668, 
    -0.000744381041707896, 0.00436348539136854, 0.999565124642623, 
    0.00294592730366657, -0.000290270785794583, 0.00215933778683979, 
    -0.000206032147339868, 0.00166224968014758, -0.000168753334077090, 
    0.00156175466378867, -0.00146846443549115, 0.00657439333932048, 
    -0.0146064563178697, 0.0132104720769013, 0.00263526256677669, 
    0.0603144544544598, -0.119670516149959, 0.0112955233448759, 
    -0.0505863067437534, 0.00504257690862256, -0.0295596613741502, 
    0.00294592730366657, 0.980043335608964, 0.00196634877295231, 
    -0.0146280526582112, 0.00139570027581210, -0.0112606187999924, 
    0.00114317266680888, -0.0105798197455082, 0.00994756326714204, 
    -0.0445346062816628, 0.0989314858838167, -0.0893837799918965, 
    -0.0184748779940085, -0.00594295862849122, 0.0117912476745855, 
    -0.00111298076941805, 0.00498431602827496, -0.00049685976968249, 
    0.00291254103060652, -0.000290270785794583, 0.00196634877295231, 
    0.999806249934247, 0.00144131567749409, -0.000137522424060199, 
    0.00110951910272332, -0.000112639545882385, 0.00104244064832165, 
    -0.000980171260964817, 0.00438827889321775, -0.00974952428930669, 
    0.00881773631250937, 0.00175895762743081, 0.0442099438211003, 
    -0.0877173949301465, 0.00827951536698293, -0.0370793006452731, 
    0.00369616278320324, -0.0216669617059942, 0.00215933778683979, 
    -0.0146280526582112, 0.00144131567749409, 0.98927777105538, 
    0.00102303554498009, -0.00825393069448538, 0.000837935116830283, 
    -0.00775491120555314, 0.00729147293494666, -0.0326434590685791, 
    0.0725158721887923, -0.0655174750813362, -0.0135420259172898, 
    -0.00421826993173935, 0.00836934314906923, -0.000789985865244395, 
    0.00353783181859127, -0.000352667544528175, 0.00206730076355104, 
    -0.000206032147339868, 0.00139570027581210, -0.000137522424060199, 
    0.00102303554498009, 0.999902387557614, 0.000787528711904935, 
    -7.99507494204464e-05, 0.00073991691047671, -0.000695718651576333, 
    0.00311476986857953, -0.0069201491471417, 0.00625880740744091, 
    0.00124825773414265, 0.0340326397397744, -0.067524513994841, 
    0.00637353815342267, -0.0285435033420056, 0.00284529147852675, 
    -0.0166791439726083, 0.00166224968014758, -0.0112606187999924, 
    0.00110951910272332, -0.00825393069448538, 0.000787528711904935, 
    0.993646155818402, 0.000645039161967345, -0.00596970083507124, 
    0.00561294659971029, -0.0251287986161794, 0.0558223631439623, 
    -0.0504346213226643, -0.0104273589980262, -0.00345502934478953, 
    0.00685505655686588, -0.000647048290070637, 0.00289772288854229, 
    -0.000288856980472801, 0.00169325876616235, -0.000168753334077090, 
    0.00114317266680888, -0.000112639545882385, 0.000837935116830283, 
    -7.99507494204464e-05, 0.000645039161967345, 0.999934515200292, 
    0.000606041684102042, -0.000569836124972143, 0.00255116944607559, 
    -0.00566780648033099, 0.0051247505259998, 0.00103181446833413, 
    0.0319751205063959, -0.0634420895652346, 0.00598821167168013, 
    -0.0268178086504621, 0.00267327302840267, -0.0156707495275378, 
    0.00156175466378867, -0.0105798197455082, 0.00104244064832165, 
    -0.00775491120555314, 0.00073991691047671, -0.00596970083507124, 
    0.000606041684102042, 0.994391217378004, 0.00527360636538786, 
    -0.0236096327522278, 0.0524480055941131, -0.0473889972485733, 
    -0.009776380267127, -0.0300651109735747, 0.0596507516141745, 
    -0.00563051039655368, 0.0252151600555397, -0.00251358709484486, 
    0.0147342559818771, -0.00146846443549115, 0.00994756326714204, 
    -0.000980171260964817, 0.00729147293494666, -0.000695718651576333, 
    0.00561294659971029, -0.000569836124972143, 0.00527360636538785, 
    0.995041345378258, 0.0222004235501176, -0.0493258027705393, 
    0.0446325171670984, 0.00875762446487243, 0.134603100039853, 
    -0.267052610398076, 0.0252080943539133, -0.112886663323073, 
    0.0112534630416396, -0.0659643242670458, 0.00657439333932048, 
    -0.0445346062816628, 0.00438827889321775, -0.0326434590685791, 
    0.00311476986857953, -0.0251287986161794, 0.00255116944607559, 
    -0.0236096327522278, 0.0222004235501176, 0.900602960888079, 
    0.220879018711456, -0.200131813647985, -0.0373955075841683, 
    -0.299050299976079, 0.59324452967942, -0.0560053087642936, 
    0.250772293108716, -0.0250020355940320, 0.146536573703041, 
    -0.0146064563178696, 0.0989314858838167, -0.0097495242893067, 
    0.0725158721887922, -0.0069201491471417, 0.0558223631439622, 
    -0.00566780648033098, 0.0524480055941131, -0.0493258027705392, 
    0.220879018711456, 0.50881050359623, 0.447806280013729, 0.0645267778200444, 
    0.270469136346909, -0.535991530768398, 0.0506527079007521, 
    -0.226570694769991, 0.0226125135895159, -0.132394583576291, 
    0.0132104720769013, -0.0893837799918967, 0.00881773631250938, 
    -0.0655174750813361, 0.00625880740744095, -0.0504346213226643, 
    0.00512475052599981, -0.0473889972485736, 0.0446325171670983, 
    -0.200131813647987, 0.447806280013724, 0.570363724750268, 
    0.0858205055531288, 0.0539539588118367, -0.110784953372769, 
    0.0101043474042827, -0.0468302620709743, 0.00451080908944944, 
    -0.0273648497100646, 0.00263526256677695, -0.0184748779940108, 
    0.00175895762743041, -0.0135420259172922, 0.00124825773414247, 
    -0.0104273589980273, 0.00103181446833428, -0.00977638026712839, 
    0.00875762446487273, -0.0373955075841508, 0.064526777820004, 
    0.0858205055536745, 0.0129629413033220), .Dim = c(19L, 19L
    )), structure(c(0.99997523679275, 2.99812612236576e-05, -4.63758460740699e-06, 
    1.26734748696451e-05, -2.07032236530683e-06, 7.40563381483813e-06, 
    -1.20950596087998e-06, 4.99977541961152e-06, -8.07467796167385e-07, 
    3.6642299284492e-06, -5.74354374428882e-07, 2.80655847562491e-06, 
    -4.22190210945228e-07, 2.74230620085809e-06, -4.80682593937733e-06, 
    3.08117642000661e-05, -0.000163557667747080, 0.000886891950516606, 
    -0.00496967741886249, 3.86535436303195e-10, 2.99812612236576e-05, 
    0.999963701146806, 5.61480724850696e-06, -1.53440043871548e-05, 
    2.50657659267384e-06, -8.9661343012329e-06, 1.46437066084243e-06, 
    -6.05331819113443e-06, 9.77615810526752e-07, -4.43634919988150e-06, 
    6.95381190373172e-07, -3.39795091762399e-06, 5.11153295807875e-07, 
    -3.32015953080646e-06, 5.81971077867141e-06, -3.73043581120882e-05, 
    0.000198022215475800, -0.00107377606533575, 0.00601687799929373, 
    -7.50297690548974e-10, -4.63758460740699e-06, 5.61480724850696e-06, 
    0.999999131486048, 2.3734531389795e-06, -3.87724216695002e-07, 
    1.38690651180913e-06, -2.26512913702994e-07, 9.3634404028307e-07, 
    -1.51220323956187e-07, 6.8622679376204e-07, -1.07563490431493e-07, 
    5.25604468562613e-07, -7.90666089388337e-08, 5.13571481177508e-07, 
    -9.00208998060106e-07, 5.77034153697664e-06, -3.06306252950611e-05, 
    0.000166094658768848, -0.000930707370380809, 7.23892818707523e-11, 
    1.26734748696451e-05, -1.53440043871548e-05, 2.3734531389795e-06, 
    0.999993513886806, 1.05956301234673e-06, -3.79010332143311e-06, 
    6.19008807921262e-07, -2.55881750273976e-06, 4.13251107565216e-07, 
    -1.87530336626744e-06, 2.93946808150427e-07, -1.43635870557755e-06, 
    2.16071245323251e-07, -1.40347525952930e-06, 2.46006856589128e-06, 
    -1.57690445887158e-05, 8.37066043600496e-05, -0.000453899316581147, 
    0.00254341375264089, -3.17160737216372e-10, -2.07032236530683e-06, 
    2.50657659267384e-06, -3.87724216695002e-07, 1.05956301234673e-06, 
    0.999999826911165, 6.1914634730375e-07, -1.01120473472576e-07, 
    4.18005097982178e-07, -6.7508163252786e-08, 3.06347117965080e-07, 
    -4.80187681266476e-08, 2.34641689303609e-07, -3.52971175067277e-08, 
    2.29269892341662e-07, -4.01873600140387e-07, 2.57601060698305e-06, 
    -1.36742019779895e-05, 7.41484017904356e-05, -0.000415488761407776, 
    3.23162112923400e-11, 7.40563381483813e-06, -8.9661343012329e-06, 
    1.38690651180913e-06, -3.79010332143311e-06, 6.1914634730375e-07, 
    0.999997785286387, 3.61712364349581e-07, -1.49522255097349e-06, 
    2.41479657921945e-07, -1.09581706399823e-06, 1.71765237600025e-07, 
    -8.39323603800232e-07, 1.26259335915254e-07, -8.20108450694383e-07, 
    1.43751947636875e-06, -9.21450281276755e-06, 4.89132196299859e-05, 
    -0.000265232082122666, 0.00148622150478996, -1.85330075072731e-10, 
    -1.20950596087998e-06, 1.46437066084243e-06, -2.26512913702994e-07, 
    6.19008807921262e-07, -1.01120473472576e-07, 3.61712364349581e-07, 
    0.999999940924265, 2.44203350241417e-07, -3.94390396541952e-08, 
    1.78971483613496e-07, -2.80531125280512e-08, 1.37080353591022e-07, 
    -2.06209790038862e-08, 1.33942088480725e-07, -2.34779145042978e-07, 
    1.50493480466956e-06, -7.98862490199871e-06, 4.33183428137115e-05, 
    -0.000242733277687828, 1.88794772121271e-11, 4.99977541961152e-06, 
    -6.05331819113443e-06, 9.3634404028307e-07, -2.55881750273976e-06, 
    4.18005097982178e-07, -1.49522255097349e-06, 2.44203350241417e-07, 
    0.999998990528408, 1.63030483035128e-07, -7.39820433734069e-07, 
    1.15964093603392e-07, -5.66653662374188e-07, 8.52416335980228e-08, 
    -5.53680910468712e-07, 9.7051443844829e-07, -6.2209995550831e-06, 
    3.30228471073017e-05, -0.00017906648881724, 0.00100339470375356, 
    -1.25122206010748e-10, -8.07467796167385e-07, 9.77615810526752e-07, 
    -1.51220323956187e-07, 4.13251107565216e-07, -6.7508163252786e-08, 
    2.41479657921945e-07, -3.94390396541952e-08, 1.63030483035128e-07, 
    0.999999973670444, 1.19481601682274e-07, -1.87282954208681e-08, 
    9.15150272855683e-08, -1.3766593145988e-08, 8.94199173031774e-08, 
    -1.56738871047804e-07, 1.00469648716573e-06, -5.33321666255508e-06, 
    2.89193835638169e-05, -0.000162049060633382, 1.26018082537529e-11, 
    3.6642299284492e-06, -4.43634919988150e-06, 6.8622679376204e-07, 
    -1.87530336626744e-06, 3.0634711796508e-07, -1.09581706399823e-06, 
    1.78971483613496e-07, -7.39820433734069e-07, 1.19481601682274e-07, 
    0.999999457801212, 8.49876377927492e-08, -4.15288514878571e-07, 
    6.24717949839526e-08, -4.05781058683651e-07, 7.11269557709576e-07, 
    -4.5592393340691e-06, 2.42017479862284e-05, -0.000131234052020166, 
    0.000735366810501042, -9.17129476852795e-11, -5.74354374428882e-07, 
    6.95381190373172e-07, -1.07563490431493e-07, 2.93946808150427e-07, 
    -4.80187681266476e-08, 1.71765237600025e-07, -2.80531125280512e-08, 
    1.15964093603392e-07, -1.87282954208681e-08, 8.49876377927492e-08, 
    0.999999986678505, 6.50949257628954e-08, -9.79222085625047e-09, 
    6.36046674652798e-08, -1.11488850275694e-07, 7.14643760551097e-07, 
    -3.79353372909071e-06, 2.05704481770091e-05, -0.000115266004772753, 
    8.94573226094294e-12, 2.80655847562491e-06, -3.39795091762399e-06, 
    5.25604468562613e-07, -1.43635870557755e-06, 2.34641689303609e-07, 
    -8.39323603800232e-07, 1.37080353591022e-07, -5.66653662374188e-07, 
    9.15150272855683e-08, -4.15288514878571e-07, 6.50949257628954e-08, 
    0.999999681916385, 4.78492750518848e-08, -3.10801530399224e-07, 
    5.4478557421986e-07, -3.49207665602186e-06, 1.85369428944200e-05, 
    -0.000100516629190810, 0.000563242480686367, -7.05879859797083e-11, 
    -4.22190210945228e-07, 5.11153295807875e-07, -7.90666089388337e-08, 
    2.16071245323251e-07, -3.52971175067277e-08, 1.26259335915254e-07, 
    -2.06209790038862e-08, 8.52416335980228e-08, -1.3766593145988e-08, 
    6.24717949839526e-08, -9.79222085625047e-09, 4.78492750518848e-08, 
    0.99999999280204, 4.67538320761804e-08, -8.19520200620752e-08, 
    5.25312617872501e-07, -2.78850980617186e-06, 1.51207029000607e-05, 
    -8.47284899992485e-05, 7.28526274102343e-12, 2.74230620085809e-06, 
    -3.32015953080646e-06, 5.13571481177508e-07, -1.40347525952930e-06, 
    2.29269892341662e-07, -8.20108450694383e-07, 1.33942088480725e-07, 
    -5.53680910468712e-07, 8.94199173031774e-08, -4.05781058683651e-07, 
    6.36046674652798e-08, -3.10801530399224e-07, 4.67538320761804e-08, 
    0.99999969631384, 5.32313461948626e-07, -3.4121303906017e-06, 
    1.81125652238553e-05, -9.8215439982214e-05, 0.000550347823067894, 
    -6.6411901579025e-11, -4.80682593937733e-06, 5.81971077867141e-06, 
    -9.00208998060106e-07, 2.46006856589128e-06, -4.01873600140387e-07, 
    1.43751947636875e-06, -2.34779145042978e-07, 9.7051443844829e-07, 
    -1.56738871047804e-07, 7.11269557709576e-07, -1.11488850275694e-07, 
    5.4478557421986e-07, -8.19520200620752e-08, 5.32313461948626e-07, 
    0.999999066939295, 5.98092104556004e-06, -3.17484416289649e-05, 
    0.000172156021237212, -0.000964672067172816, 6.43782124919265e-11, 
    3.08117642000661e-05, -3.73043581120882e-05, 5.77034153697664e-06, 
    -1.57690445887158e-05, 2.57601060698305e-06, -9.21450281276755e-06, 
    1.50493480466956e-06, -6.2209995550831e-06, 1.00469648716573e-06, 
    -4.5592393340691e-06, 7.14643760551097e-07, -3.49207665602186e-06, 
    5.25312617872501e-07, -3.4121303906017e-06, 5.98092104556004e-06, 
    0.999961662283744, 0.000203507576419118, -0.00110352045172447, 
    0.00618354994313972, -2.96286174505503e-10, -0.000163557667747080, 
    0.000198022215475800, -3.06306252950611e-05, 8.37066043600496e-05, 
    -1.36742019779895e-05, 4.89132196299859e-05, -7.98862490199871e-06, 
    3.30228471073017e-05, -5.33321666255508e-06, 2.42017479862284e-05, 
    -3.79353372909071e-06, 1.85369428944200e-05, -2.78850980617186e-06, 
    1.81125652238553e-05, -3.17484416289649e-05, 0.000203507576419118, 
    0.99891972350717, 0.00585780256603652, -0.0328240538428941, 
    7.40778978664778e-10, 0.000886891950516606, -0.00107377606533575, 
    0.000166094658768849, -0.000453899316581147, 7.41484017904356e-05, 
    -0.000265232082122666, 4.33183428137115e-05, -0.00017906648881724, 
    2.89193835638169e-05, -0.000131234052020166, 2.05704481770091e-05, 
    -0.000100516629190810, 1.51207029000607e-05, -9.8215439982214e-05, 
    0.000172156021237212, -0.00110352045172447, 0.00585780256603652, 
    0.968236047779997, 0.177988531736728, -1.31113283242747e-09, 
    -0.00496967741886249, 0.00601687799929373, -0.00093070737038081, 
    0.00254341375264089, -0.000415488761407776, 0.00148622150478996, 
    -0.000242733277687828, 0.00100339470375356, -0.000162049060633382, 
    0.000735366810501042, -0.000115266004772753, 0.000563242480686367, 
    -8.47284899992486e-05, 0.000550347823067894, -0.000964672067172817, 
    0.00618354994313972, -0.0328240538428941, 0.177988531736728, 
    0.00264560246232048, 4.20381674777824e-09, 3.96063626340037e-10, 
    -7.51192885672936e-10, 7.18518577969007e-11, -3.23222337783591e-10, 
    3.16724424465065e-11, -1.90517823739356e-10, 1.91171523056255e-11, 
    -1.25574217690883e-10, 1.2848389019382e-11, -9.35793664780249e-11, 
    8.87467876964365e-12, -7.09237113483141e-11, 7.10342895615668e-12, 
    -6.58522125718264e-11, 6.3584693066332e-11, -2.85382384390687e-10, 
    6.02142335992539e-10, -1.14118847704958e-09, 7.03948899172246e-09, 
    0.014051283323416), .Dim = c(20L, 20L)))
`MMnorm12` <-
list(structure(c(0.977205023723124, 0), .Dim = c(2L, 1L)), structure(c(0.977205023723124, 
0, 2.23606816251288e-10, 1.23280888807427), .Dim = c(2L, 2L)), 
    structure(c(0.977205023723124, 0, 2.23606816251288e-10, 1.23280888807427, 
    0.183008240031890, -3.30454577584812e-15), .Dim = 2:3), structure(c(0.977205023723124, 
    0, 2.23606816251288e-10, 1.23280888807427, 0.183008240031890, 
    -3.30454577584812e-15, -1.79998266292003e-09, 0.521124588000013
    ), .Dim = c(2L, 4L)), structure(c(0.977205023723124, 0, 2.23606816251288e-10, 
    1.23280888807427, 0.183008240031890, -3.30454577584812e-15, 
    -1.79998266292003e-09, 0.521124588000013, 0.081698992568508, 
    -1.3929854269323e-08), .Dim = c(2L, 5L)), structure(c(0.977205023723124, 
    0, 2.23606816251288e-10, 1.23280888807427, 0.183008240031890, 
    -3.30454577584812e-15, -1.79998266292003e-09, 0.521124588000013, 
    0.081698992568508, -1.3929854269323e-08, -7.7519022437197e-08, 
    0.3045144998136), .Dim = c(2L, 6L)), structure(c(0.977205023723124, 
    0, 2.23606816251288e-10, 1.23280888807427, 0.183008240031890, 
    -3.30454577584812e-15, -1.79998266292003e-09, 0.521124588000013, 
    0.081698992568508, -1.3929854269323e-08, -7.7519022437197e-08, 
    0.3045144998136, 0.0477295778133786, 8.9464549897464e-08), .Dim = c(2L, 
    7L)), structure(c(0.977205023723124, 0, 2.23606816251288e-10, 
    1.23280888807427, 0.183008240031890, -3.30454577584812e-15, 
    -1.79998266292003e-09, 0.521124588000013, 0.081698992568508, 
    -1.3929854269323e-08, -7.7519022437197e-08, 0.3045144998136, 
    0.0477295778133786, 8.9464549897464e-08, 2.22665619947903e-07, 
    0.205587566336692), .Dim = c(2L, 8L)), structure(c(0.977205023723124, 
    0, 2.23606816251288e-10, 1.23280888807427, 0.183008240031890, 
    -3.30454577584812e-15, -1.79998266292003e-09, 0.521124588000013, 
    0.081698992568508, -1.3929854269323e-08, -7.7519022437197e-08, 
    0.3045144998136, 0.0477295778133786, 8.9464549897464e-08, 
    2.22665619947903e-07, 0.205587566336692, 0.0318733652194164, 
    9.47446740454069e-06), .Dim = c(2L, 9L)), structure(c(0.977205023723124, 
    0, 2.23606816251288e-10, 1.23280888807427, 0.183008240031890, 
    -3.30454577584812e-15, -1.79998266292003e-09, 0.521124588000013, 
    0.081698992568508, -1.3929854269323e-08, -7.7519022437197e-08, 
    0.3045144998136, 0.0477295778133786, 8.9464549897464e-08, 
    2.22665619947903e-07, 0.205587566336692, 0.0318733652194164, 
    9.47446740454069e-06, 5.68335880297501e-05, 0.150729840706819
    ), .Dim = c(2L, 10L)), structure(c(0.977205023723124, 0, 
    2.23606816251288e-10, 1.23280888807427, 0.183008240031890, 
    -3.30454577584812e-15, -1.79998266292003e-09, 0.521124588000013, 
    0.081698992568508, -1.3929854269323e-08, -7.7519022437197e-08, 
    0.3045144998136, 0.0477295778133786, 8.9464549897464e-08, 
    2.22665619947903e-07, 0.205587566336692, 0.0318733652194164, 
    9.47446740454069e-06, 5.68335880297501e-05, 0.150729840706819, 
    0.0227469480714439, 8.52261690623742e-05), .Dim = c(2L, 11L
    )), structure(c(0.977205023723124, 0, 2.23606816251288e-10, 
    1.23280888807427, 0.183008240031890, -3.30454577584812e-15, 
    -1.79998266292003e-09, 0.521124588000013, 0.081698992568508, 
    -1.3929854269323e-08, -7.7519022437197e-08, 0.3045144998136, 
    0.0477295778133786, 8.9464549897464e-08, 2.22665619947903e-07, 
    0.205587566336692, 0.0318733652194164, 9.47446740454069e-06, 
    5.68335880297501e-05, 0.150729840706819, 0.0227469480714439, 
    8.52261690623742e-05, 0.00147644047823897, 0.11694220725043
    ), .Dim = c(2L, 12L)), structure(c(0.977205023723124, 0, 
    2.23606816251288e-10, 1.23280888807427, 0.183008240031890, 
    -3.30454577584812e-15, -1.79998266292003e-09, 0.521124588000013, 
    0.081698992568508, -1.3929854269323e-08, -7.7519022437197e-08, 
    0.3045144998136, 0.0477295778133786, 8.9464549897464e-08, 
    2.22665619947903e-07, 0.205587566336692, 0.0318733652194164, 
    9.47446740454069e-06, 5.68335880297501e-05, 0.150729840706819, 
    0.0227469480714439, 8.52261690623742e-05, 0.00147644047823897, 
    0.11694220725043, 0.0137470668940847, -0.00303574979864906
    ), .Dim = c(2L, 13L)), structure(c(0.977205023723124, 0, 
    2.23606816251288e-10, 1.23280888807427, 0.183008240031890, 
    -3.30454577584812e-15, -1.79998266292003e-09, 0.521124588000013, 
    0.081698992568508, -1.3929854269323e-08, -7.7519022437197e-08, 
    0.3045144998136, 0.0477295778133786, 8.9464549897464e-08, 
    2.22665619947903e-07, 0.205587566336692, 0.0318733652194164, 
    9.47446740454069e-06, 5.68335880297501e-05, 0.150729840706819, 
    0.0227469480714439, 8.52261690623742e-05, 0.00147644047823897, 
    0.11694220725043, 0.0137470668940847, -0.00303574979864906, 
    -0.00928615179284165, 0.103085593678959), .Dim = c(2L, 14L
    )), structure(c(0.977205023723124, 0, 2.23606816251288e-10, 
    1.23280888807427, 0.183008240031890, -3.30454577584812e-15, 
    -1.79998266292003e-09, 0.521124588000013, 0.081698992568508, 
    -1.3929854269323e-08, -7.7519022437197e-08, 0.3045144998136, 
    0.0477295778133786, 8.9464549897464e-08, 2.22665619947903e-07, 
    0.205587566336692, 0.0318733652194164, 9.47446740454069e-06, 
    5.68335880297501e-05, 0.150729840706819, 0.0227469480714439, 
    8.52261690623742e-05, 0.00147644047823897, 0.11694220725043, 
    0.0137470668940847, -0.00303574979864906, -0.00928615179284165, 
    0.103085593678959, 0.234330805463596, 0.0465189445727412), .Dim = c(2L, 
    15L)), structure(c(0.977205023723124, 0, 2.23606816251288e-10, 
    1.23280888807427, 0.183008240031890, -3.30454577584812e-15, 
    -1.79998266292003e-09, 0.521124588000013, 0.081698992568508, 
    -1.3929854269323e-08, -7.7519022437197e-08, 0.3045144998136, 
    0.0477295778133786, 8.9464549897464e-08, 2.22665619947903e-07, 
    0.205587566336692, 0.0318733652194164, 9.47446740454069e-06, 
    5.68335880297501e-05, 0.150729840706819, 0.0227469480714439, 
    8.52261690623742e-05, 0.00147644047823897, 0.11694220725043, 
    0.0137470668940847, -0.00303574979864906, -0.00928615179284165, 
    0.103085593678959, 0.234330805463596, 0.0465189445727412, 
    -1.98978137872651, -0.806390449226108), .Dim = c(2L, 16L)), 
    structure(c(0.977205023723124, 0, 2.23606816251288e-10, 1.23280888807427, 
    0.183008240031890, -3.30454577584812e-15, -1.79998266292003e-09, 
    0.521124588000013, 0.081698992568508, -1.3929854269323e-08, 
    -7.7519022437197e-08, 0.3045144998136, 0.0477295778133786, 
    8.9464549897464e-08, 2.22665619947903e-07, 0.205587566336692, 
    0.0318733652194164, 9.47446740454069e-06, 5.68335880297501e-05, 
    0.150729840706819, 0.0227469480714439, 8.52261690623742e-05, 
    0.00147644047823897, 0.11694220725043, 0.0137470668940847, 
    -0.00303574979864906, -0.00928615179284165, 0.103085593678959, 
    0.234330805463596, 0.0465189445727412, -1.98978137872651, 
    -0.806390449226108, 14.0490612099788, 7.9137204989213), .Dim = c(2L, 
    17L)), structure(c(0.977205023723124, 0, 2.23606816251288e-10, 
    1.23280888807427, 0.183008240031890, -3.30454577584812e-15, 
    -1.79998266292003e-09, 0.521124588000013, 0.081698992568508, 
    -1.3929854269323e-08, -7.7519022437197e-08, 0.3045144998136, 
    0.0477295778133786, 8.9464549897464e-08, 2.22665619947903e-07, 
    0.205587566336692, 0.0318733652194164, 9.47446740454069e-06, 
    5.68335880297501e-05, 0.150729840706819, 0.0227469480714439, 
    8.52261690623742e-05, 0.00147644047823897, 0.11694220725043, 
    0.0137470668940847, -0.00303574979864906, -0.00928615179284165, 
    0.103085593678959, 0.234330805463596, 0.0465189445727412, 
    -1.98978137872651, -0.806390449226108, 14.0490612099788, 
    7.9137204989213, -87.5203589925242, -54.7276872419126), .Dim = c(2L, 
    18L)), structure(c(0.977205023723124, 0, 2.23606816251288e-10, 
    1.23280888807427, 0.183008240031890, -3.30454577584812e-15, 
    -1.79998266292003e-09, 0.521124588000013, 0.081698992568508, 
    -1.3929854269323e-08, -7.7519022437197e-08, 0.3045144998136, 
    0.0477295778133786, 8.9464549897464e-08, 2.22665619947903e-07, 
    0.205587566336692, 0.0318733652194164, 9.47446740454069e-06, 
    5.68335880297501e-05, 0.150729840706819, 0.0227469480714439, 
    8.52261690623742e-05, 0.00147644047823897, 0.11694220725043, 
    0.0137470668940847, -0.00303574979864906, -0.00928615179284165, 
    0.103085593678959, 0.234330805463596, 0.0465189445727412, 
    -1.98978137872651, -0.806390449226108, 14.0490612099788, 
    7.9137204989213, -87.5203589925242, -54.7276872419126, 503.59029517106, 
    320.39056589639), .Dim = c(2L, 19L)), structure(c(0.977205023723124, 
    0, 2.23606816251288e-10, 1.23280888807427, 0.183008240031890, 
    -3.30454577584812e-15, -1.79998266292003e-09, 0.521124588000013, 
    0.081698992568508, -1.3929854269323e-08, -7.7519022437197e-08, 
    0.3045144998136, 0.0477295778133786, 8.9464549897464e-08, 
    2.22665619947903e-07, 0.205587566336692, 0.0318733652194164, 
    9.47446740454069e-06, 5.68335880297501e-05, 0.150729840706819, 
    0.0227469480714439, 8.52261690623742e-05, 0.00147644047823897, 
    0.11694220725043, 0.0137470668940847, -0.00303574979864906, 
    -0.00928615179284165, 0.103085593678959, 0.234330805463596, 
    0.0465189445727412, -1.98978137872651, -0.806390449226108, 
    14.0490612099788, 7.9137204989213, -87.5203589925242, -54.7276872419126, 
    503.59029517106, 320.39056589639, 4131932941.74848, 4305467590.14660
    ), .Dim = c(2L, 20L)))
`ddst.polynomial.fun` <-
list(function (x) 
{
    w <- 0
    w <- 1 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 3.46410161513775 + x * w
    w <- -1.73205080756888 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 13.4164078649987 + x * w
    w <- -13.4164078649987 + x * w
    w <- 2.23606797749979 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 52.9150262212918 + x * w
    w <- -79.3725393319377 + x * w
    w <- 31.7490157327751 + x * w
    w <- -2.64575131106459 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 210 + x * w
    w <- -420 + x * w
    w <- 270 + x * w
    w <- -60 + x * w
    w <- 3 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 835.78944716956 + x * w
    w <- -2089.4736179239 + x * w
    w <- 1857.30988259902 + x * w
    w <- -696.491205974634 + x * w
    w <- 99.498743710662 + x * w
    w <- -3.3166247903554 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 3331.52937852873 + x * w
    w <- -9994.58813558618 + x * w
    w <- 11357.4865177116 + x * w
    w <- -6057.3261427795 + x * w
    w <- 1514.33153569488 + x * w
    w <- -151.433153569488 + x * w
    w <- 3.60555127546399 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 13292.0788441839 + x * w
    w <- -46522.2759546435 + x * w
    w <- 64415.4590141218 + x * w
    w <- -44732.9576486957 + x * w
    w <- 16266.5300540712 + x * w
    w <- -2927.97540973281 + x * w
    w <- 216.887067387615 + x * w
    w <- -3.87298334620742 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 53064.3694016993 + x * w
    w <- -212257.477606797 + x * w
    w <- 346687.213424435 + x * w
    w <- -297160.468649516 + x * w
    w <- 142865.609927652 + x * w
    w <- -38097.4959807072 + x * w
    w <- 5195.11308827826 + x * w
    w <- -296.863605044472 + x * w
    w <- 4.12310562561767 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 211929.666634948 + x * w
    w <- -953683.499857264 + x * w
    w <- 1795168.94090779 + x * w
    w <- -1832568.29384337 + x * w
    w <- 1099540.97630602 + x * w
    w <- -392693.205823580 + x * w
    w <- 80552.4524766317 + x * w
    w <- -8630.61990821054 + x * w
    w <- 392.300904918661 + x * w
    w <- -4.35889894354068 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 846658.355097261 + x * w
    w <- -4233291.77548631 + x * w
    w <- 9023595.6266945 + x * w
    w <- -10694631.8538601 + x * w
    w <- 7706425.89469334 + x * w
    w <- -3467891.652612 + x * w
    w <- 963303.236836668 + x * w
    w <- -157273.997850885 + x * w
    w <- 13610.2498140189 + x * w
    w <- -504.083326445142 + x * w
    w <- 4.58257569495585 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 3383133.02315354 + x * w
    w <- -18607231.6273445 + x * w
    w <- 44302932.4460583 + x * w
    w <- -59808958.8021787 + x * w
    w <- 50365438.9913083 + x * w
    w <- -27421183.4508234 + x * w
    w <- 9678064.74734945 + x * w
    w <- -2160282.30967622 + x * w
    w <- 288037.641290162 + x * w
    w <- -20574.1172350116 + x * w
    w <- 633.049761077279 + x * w
    w <- -4.79583152331273 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 13520780 + x * w
    w <- -81124680 + x * w
    w <- 213393180 + x * w
    w <- -323323000 + x * w
    w <- 311775750 + x * w
    w <- -199536480 + x * w
    w <- 85765680 + x * w
    w <- -24504480 + x * w
    w <- 4504500 + x * w
    w <- -500500 + x * w
    w <- 30030.0000000000 + x * w
    w <- -780 + x * w
    w <- 5.00000000000002 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 54043102.8876026 + x * w
    w <- -351280168.769417 + x * w
    w <- 1011686886.05592 + x * w
    w <- -1700196016.84398 + x * w
    w <- 1848039148.74345 + x * w
    w <- -1360828827.71109 + x * w
    w <- 691214642.646902 + x * w
    w <- -241925124.926416 + x * w
    w <- 57298055.9036248 + x * w
    w <- -8842292.57771988 + x * w
    w <- 832215.772020695 + x * w
    w <- -42556.4883419674 + x * w
    w <- 945.699740932607 + x * w
    w <- -5.19615242270665 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 216034502.501892 + x * w
    w <- -1512241517.51324 + x * w
    w <- 4732755860.36552 + x * w
    w <- -8737395434.52097 + x * w
    w <- 10572248475.7704 + x * w
    w <- -8810207063.14198 + x * w
    w <- 5171208493.58333 + x * w
    w <- -2149073659.67100 + x * w
    w <- 626813150.737374 + x * w
    w <- -125362630.147475 + x * w
    w <- 16495082.9141414 + x * w
    w <- -1332935.99306193 + x * w
    w <- 58805.9996939088 + x * w
    w <- -1130.88460949825 + x * w
    w <- 5.38516480713452 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 863657799.906573 + x * w
    w <- -6477433499.2993 + x * w
    w <- 21889258032.1149 + x * w
    w <- -44039102469.374 + x * w
    w <- 58718803292.4986 + x * w
    w <- -54653655372.2487 + x * w
    w <- 36435770248.1658 + x * w
    w <- -17567246369.6514 + x * w
    w <- 6110346563.357 + x * w
    w <- -1512156472.74997 + x * w
    w <- 259226823.899994 + x * w
    w <- -29457593.6249993 + x * w
    w <- 2067199.55263153 + x * w
    w <- -79507.6751012128 + x * w
    w <- 1336.26344707920 + x * w
    w <- -5.56776436283004 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 3452943955.96051 + x * w
    w <- -27623551647.6841 + x * w
    w <- 100246760011.757 + x * w
    w <- -218315166247.826 + x * w
    w <- 318062612895.539 + x * w
    w <- -327150116121.126 + x * w
    w <- 244352864510.224 + x * w
    w <- -134259815664.958 + x * w
    w <- 54375225344.3081 + x * w
    w <- -16111177879.795 + x * w
    w <- 3432381374.39111 + x * w
    w <- -510602187.92595 + x * w
    w <- 50654978.9609077 + x * w
    w <- -3117229.4745174 + x * w
    w <- 105470.170190438 + x * w
    w <- -1562.52103985834 + x * w
    w <- 5.74456264653804 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 13805800579.8575 + x * w
    w <- -117349304928.789 + x * w
    w <- 455173061541.969 + x * w
    w <- -1066811862988.99 + x * w
    w <- 1686251009240.66 + x * w
    w <- -1899842803744.48 + x * w
    w <- 1572283699650.60 + x * w
    w <- -970644528865.934 + x * w
    w <- 449372467067.562 + x * w
    w <- -155552007831.079 + x * w
    w <- 39821314004.7563 + x * w
    w <- -7391077220.57976 + x * w
    w <- 964053550.510404 + x * w
    w <- -84270415.2544059 + x * w
    w <- 4586145.04785882 + x * w
    w <- -137584.351435765 + x * w
    w <- 1810.32041362848 + x * w
    w <- -5.91607978309963 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 55201892960.2267 + x * w
    w <- -496817036642.04 + x * w
    w <- 2051144622707.85 + x * w
    w <- -5147970817776.57 + x * w
    w <- 8774950257573.7 + x * w
    w <- -10749314065527.8 + x * w
    w <- 9766849876742.99 + x * w
    w <- -6697268486909.48 + x * w
    w <- 3492971926362.27 + x * w
    w <- -1386099970778.68 + x * w
    w <- 415829991233.604 + x * w
    w <- -93052865171.156 + x * w
    w <- 15198634644.6222 + x * w
    w <- -1753688612.84102 + x * w
    w <- 136155948.201942 + x * w
    w <- -6601500.51888205 + x * w
    w <- 176825.906755769 + x * w
    w <- -2080.30478536199 + x * w
    w <- 6.08276253029823 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 220731101683.863 + x * w
    w <- -2096945465996.7 + x * w
    w <- 9181220688958.53 + x * w
    w <- -24568266473231.6 + x * w
    w <- 44924830122480.7 + x * w
    w <- -59459333985636.2 + x * w
    w <- 58858734652448 + x * w
    w <- -44406813197605.9 + x * w
    w <- 25784601211513.1 + x * w
    w <- -11555321283678.1 + x * w
    w <- 3984593546095.89 + x * w
    w <- -1047896354655.09 + x * w
    w <- 206991872524.462 + x * w
    w <- -30007697496.1498 + x * w
    w <- 3086506028.17541 + x * w
    w <- -214340696.40107 + x * w
    w <- 9319160.71309 + x * w
    w <- -224257.878122487 + x * w
    w <- 2373.09923939139 + x * w
    w <- -6.24499799839841 + x * w
    w
}, function (x) 
{
    w <- 0
    w <- 882648449733.328 + x * w
    w <- -8826484497333.28 + x * w
    w <- 40850780814580.9 + x * w
    w <- -116102219157230 + x * w
    w <- 226713117138105 + x * w
    w <- -322436433263082 + x * w
    w <- 345467607067588 + x * w
    w <- -284502735232131 + x * w
    w <- 182124857023599 + x * w
    w <- -91062428511799.6 + x * w
    w <- 35543722096541.1 + x * w
    w <- -10770824877739.7 + x * w
    w <- 2507002342232.53 + x * w
    w <- -440791620612.312 + x * w
    w <- 57139654523.8183 + x * w
    w <- -5274429648.35246 + x * w
    w <- 329651853.022028 + x * w
    w <- -12927523.6479227 + x * w
    w <- 281033.122780928 + x * w
    w <- -2689.31217972179 + x * w
    w <- 6.40312423743286 + x * w
    w
})
