% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.r
\name{read_fastq}
\alias{read_fastq}
\title{Read in raw data from a fastq file.}
\usage{
read_fastq(x, keep_quality = TRUE)
}
\arguments{
\item{x}{The name of the fastq file to read data from.}

\item{keep_quality}{Boolean indicating if the Phred quality scores should be 
retained in the output dataframe. Default is TRUE.}
}
\description{
Read in raw data from a fastq file.
}
\examples{
#read in an unzipped fastq file
fastq_example_file = system.file('extdata/coi_sequel_data_subset.fastq', 
                                  package = 'debar')
data = read_fastq(fastq_example_file)
#read in a gzipped fastq file and do not keep the phred scores
gz_fastq_example_file = system.file('extdata/coi_sequel_data_subset.fastq', 
                                    package = 'debar')
data2 = read_fastq(gz_fastq_example_file, keep_quality = FALSE)
}
