% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{add_control}
\alias{add_control}
\title{Add a control to the widget}
\usage{
add_control(deckgl, html, pos = "top-right", style = NULL)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{html}{The \code{innerHTML} of the element.}

\item{pos}{The position of the control. Possible values are \code{top-left}, \code{top-right},
\code{bottom-right} and \code{bottom-left}.}

\item{style}{A \code{cssText} string that will modefiy the default style of the element.}
}
\description{
Add a control to the widget
}
\examples{
deck <- deckgl() \%>\%
  add_basemap() \%>\%
  add_control(
    "<h1>Blank Base Map</h1>",
    pos = "top-right",
    style = "background: #004080; color: white;"
  )

if (interactive()) deck
}
