% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_line-layer.R
\name{add_line_layer}
\alias{add_line_layer}
\title{Add a line layer to the deckgl widget}
\usage{
add_line_layer(
  deckgl,
  data = NULL,
  properties = list(),
  ...,
  id = "line-layer"
)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class. The \code{properties} parameter can also be an empty list. In this case
all props must be passed as named arguments.}

\item{...}{Named arguments that will be added to the \code{properties} object. Identical parameters
are overwritten.}

\item{id}{The unique id of the layer.}
}
\description{
The \code{LineLayer} renders flat lines joining pairs of source and target points,
specified as latitude/longitude coordinates.
}
\examples{
## @knitr line-layer
data("bart_segments")

properties <- list(
  pickable = TRUE,
  getWidth = 12,
  getSourcePosition = ~from_lng + from_lat,
  getTargetPosition = ~to_lng + to_lat,
  getColor = JS("d => [Math.sqrt(d.inbound + d.outbound), 140, 0]"),
  tooltip = "{{from_name}}} to {{to_name}}"
)

deck <- deckgl(zoom = 10, pitch = 20) \%>\%
  add_line_layer(data = bart_segments, properties = properties) \%>\%
  add_basemap() \%>\%
  add_control("Line Layer")

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/line-layer}
}
