% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_text-layer.R
\name{add_text_layer}
\alias{add_text_layer}
\title{Add a text layer to the deckgl widget}
\usage{
add_text_layer(
  deckgl,
  data = NULL,
  properties = list(),
  ...,
  id = "text-layer"
)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class. The \code{properties} parameter can also be an empty list. In this case
all props must be passed as named arguments.}

\item{...}{Named arguments that will be added to the \code{properties} object. Identical parameters
are overwritten.}

\item{id}{The unique id of the layer.}
}
\description{
The \code{TextLayer} renders text labels on the map using texture mapping.
}
\examples{
## @knitr text-layer
data("bart_stations")

deck <- deckgl(zoom = 10, pitch = 35) \%>\%
  add_text_layer(
    data = bart_stations,
    pickable = TRUE,
    getPosition = ~lng + lat,
    getText = ~name,
    getSize = 15,
    getAngle = 0,
    getTextAnchor = "middle",
    getAlignmentBaseline = "center",
    tooltip = "{{name}}<br/>{{address}}"
  ) \%>\%
  add_basemap(use_carto_style("voyager"))

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/text-layer}
}
