#' @importFrom Rlibeemd emd_num_imfs emd
#' @importFrom forecast auto.arima
#' @importFrom utils head tail
#' @importFrom graphics plot
#' @importFrom stats as.ts ts
#' @export
#'

emdARIMA <- function (data, stepahead = 10, num.IMFs = emd_num_imfs(length(data)),
                      s.num = 4L, num.sift = 50L)
{
  n.IMF <- num.IMFs
  AllIMF <- emd(data, num_imfs = n.IMF, S_number = s.num,
                num_siftings = num.sift)
  data_trn <- ts(head(data, round(length(data) - stepahead)))
  data_test <- ts(tail(data, stepahead))
  IMF_trn <- AllIMF[-c(((length(data) - stepahead) + 1):length(data)),
  ]
  Fcast_AllIMF <- NULL
  for (IMF in 1:ncol(IMF_trn)) {
    IndIMF <- NULL
    IndIMF <- IMF_trn[, IMF]
    emdARIMAFit <- forecast::auto.arima(as.ts(IndIMF))
    emdARIMA_fcast = forecast::forecast(emdARIMAFit, h = stepahead)
    emdARIMA_fcast_Mean = emdARIMA_fcast$mean
    Fcast_AllIMF <- cbind(Fcast_AllIMF, as.matrix(emdARIMA_fcast_Mean))
  }
  FinalemdARIMA_fcast <- ts(rowSums(Fcast_AllIMF, na.rm = T))
  MAE_emdARIMA = mean(abs(data_test - FinalemdARIMA_fcast))
  MAPE_emdARIMA = mean(abs(data_test - FinalemdARIMA_fcast)/data_test)
  RMSE_emdARIMA = sqrt(mean((data_test - FinalemdARIMA_fcast)^2))
  Plot_IMFs <- AllIMF
  AllIMF_plots <- plot(Plot_IMFs)
  return(list(TotalIMF = n.IMF, AllIMF = AllIMF, AllIMF_plots = AllIMF_plots, data_test = data_test,
              AllIMF_forecast = Fcast_AllIMF, FinalemdARIMA_forecast = FinalemdARIMA_fcast,
              MAE_emdARIMA = MAE_emdARIMA, MAPE_emdARIMA = MAPE_emdARIMA,
              RMSE_emdARIMA = RMSE_emdARIMA ))
}
