% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deflist.R
\name{deflist}
\alias{deflist}
\title{Create a deferred list}
\usage{
deflist(
  fun,
  len = 1,
  names,
  memoise = FALSE,
  cache = c("memory", "file"),
  cachedir = NULL
)
}
\arguments{
\item{fun}{A function that is used to retrieve elements.}

\item{len}{Integer, the length of the list (default is 1).}

\item{names}{Character vector, an optional set of names, one per element.}

\item{memoise}{Logical, whether to memoise the function to speed up repeated element access (default is FALSE).}

\item{cache}{Character, use an in-memory or filesystem cache if \code{memoise} is TRUE (default is "memory").}

\item{cachedir}{Character, the file path to the cache (default is NULL).}
}
\value{
An object of class "deflist" representing the deferred list.
}
\description{
A read-only list that retrieves elements with a function call.
The deferred list is useful for handling large datasets where elements are computed on-demand.
}
\details{
The deferred list is created using the provided function, length, names, and caching options.
The list is read-only, and elements are retrieved using the provided function.
}
\examples{
# Create a deferred list of squares
square_fun <- function(i) i^2
square_deflist <- deflist(square_fun, len = 5)
print(square_deflist)
cat("First element of the list:", square_deflist[[1]], "\n")
}
