% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_reads_count_primers.R
\name{read_prefilt_fastq}
\alias{read_prefilt_fastq}
\title{A function for calling read_fastq, primer_check, and remove_ns functions.
This will process and edit the FASTQ and make them ready for the trimming of
primers with 'Cutadapt'. Part of a larger 'prepare_reads' function.}
\usage{
read_prefilt_fastq(
  data_directory_path = data_directory_path,
  multithread,
  temp_directory_path
)
}
\arguments{
\item{data_directory_path}{The path to the directory containing raw FASTQ (forward and reverse reads), metadata.csv, and
primerinfo_params.csv files}

\item{multithread}{(Optional). Default is FALSE.
 If TRUE, input files are filtered in parallel via \code{\link[parallel]{mclapply}}.
 If an integer is provided, it is passed to the \code{mc.cores} argument of \code{\link[parallel]{mclapply}}.
 Note that the parallelization here is by forking, and each process is loading another fastq file into
 memory. This option is ignored in Windows, as Windows does not support forking, with \code{mc.cores} set to 1.
If memory is an issue, execute in a clean environment and reduce the chunk size \code{n} and/or
 the number of threads.}

\item{temp_directory_path}{User-defined temporary directory to output unfiltered, trimmed, and filtered read directories throughout the workflow}
}
\value{
Returns filtered reads that have no Ns
}
\description{
A function for calling read_fastq, primer_check, and remove_ns functions.
This will process and edit the FASTQ and make them ready for the trimming of
primers with 'Cutadapt'. Part of a larger 'prepare_reads' function.
}
\keyword{internal}
