% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mov.cor.R
\name{plot_mov.cor}
\alias{plot_mov.cor}
\title{Plotting moving correlation with climate.}
\usage{
plot_mov.cor(mov.cor.output, sig.only = T, ci = 0.95, clim_vars = "all")
}
\arguments{
\item{mov.cor.output}{list the output of \code{mov.cor.dm} function.}

\item{sig.only}{logical TRUE to plot only significant correlation.}

\item{ci}{numeric confidence interval}

\item{clim_vars}{array of climate variables or "all" for all climate variables.}
}
\value{
A plot with correlation.
}
\description{
This function plots the moving correlation i.e., output of \code{mov.cor.dm}.
}
\examples{
\donttest{
library(dendRoAnalyst)
data(gf_nepa17)
data(ktm_rain17)
out_corr<-mov.cor.dm(df=gf_nepa17, Clim=ktm_rain17, TreeNum=1, win_size=21)
plot_mov.cor(mov.cor.output=out_corr, sig.only=TRUE, ci=0.95)}


}
