% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.R
\name{dpdetect_s}
\alias{dpdetect_s}
\title{Detect measurement starting point automatically using changepoint
segmentation}
\usage{
dpdetect_s(
  dp,
  cutoff.sd = 1,
  return.plot = FALSE,
  minseglen = 250,
  span = 0.1,
  nroll = 100
)
}
\arguments{
\item{dp}{A dp object, see dpload.}

\item{cutoff.sd}{How many standard deviations for the cutoff limit?}

\item{return.plot}{If true, will return a plot displaying segment
detection for the current dp file.}

\item{minseglen}{Minimum segment length for segment detection,
default setting of 250 points is for data resolution of 1/100 mm,
test a few options with return.plot = TRUE to find the right value}

\item{span}{Span for loess regression, use to adjust sensitivity
of detection detection for the current dp file.}

\item{nroll}{Number of points for rolling mean, use to adjust
sensitivity of detection for the current dp file.}
}
\value{
Either a row number where the actual measurement starts or
  a plot, displaying changepoint segmentation and set limits.
}
\description{
A typical resistance drilling measurement starts with an increase
in resistance values in between the measurement start and the
immersion of the needle in the wood. These values are not useful
when estimating density and should be removed before further
analysis. This function will detect the starting point
automatically using binary segmentation from the package
\code{changepoint}, which separates the measurement in segments
based on their mean and variance. Start is detected, when the
segment mean is outside of the cutoff limit, see \code{return.plot
= TRUE} to display the diagnostic plot. This function will only
check the mean values of the first four (4) segments and compare
them to the cutoff value. The function is called on a dp object
and returns either a row number of the starting point or a plot
displaying the segmentation and detection. The sensitivity can be
adjusted using the cutoff.sd parameter, which is an indicator on
how many standard deviations the segment mean value can be before
cutting it off. Will return a warning if start not detected.
}
\examples{
## load a single file
dp <- dpload(system.file("extdata", "00010001.dpa", package = "densitr"))
## get starting point
start <- dpdetect_s(dp)
## plot the start detection
\donttest{
dpdetect_s(dp, return.plot = TRUE)
}
}
\seealso{
dpdetect_e, dptrim, dptriml, dptrim_s, dptriml_s
}
