% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{dpload}
\alias{dpload}
\title{Load a single density profile measurement file (*.dpa) or a directory
of *.dpa files.}
\usage{
dpload(dp.file = NULL, dp.directory = "", recursive = TRUE, name = "file")
}
\arguments{
\item{dp.file}{A path to a single file, including file name.}

\item{dp.directory}{A directory with .dpa files.}

\item{recursive}{Also look for density profiles files in subfolders?}

\item{name}{Either \code{c("file", "folder")}, used for naming of
list items. If "file", only file name without the complete path
will be used for naming ("00050060"). If "folder", the complete
path along with file name will be used to name the dpa objects
("data/0005/00/00050060"). *.dpa ending is removed from the name
in both cases.}
}
\value{
A \code{dp} object or a list of \code{dp} objects.
}
\description{
Loads either a single .dpa file or a list of .dpa files. If
dpa.file is specified, it will load a single file. If dp.directory
is specified, it will search for all dpa files in that directory
(recursively in all subfolders, can be turned off) and return a
list of dp files. It will use pbapply to display progress, if
loading a directory.
}
\details{
NOTE: for now this function only supports loading density profiles
created by the Rinntech Resistograph® resistance drilling device
(*.dpa). It was tested to work on files produced by R650-RC drill.
}
\examples{
## load a single file
dpload(system.file("extdata", "00010001.dpa", package = "densitr"))
dp <- dpload(system.file("extdata", "00010001.dpa", package = "densitr"))
## load all files in directory
dp.list <- dpload(dp.directory = system.file("extdata", package = "densitr"))
}
