#' @keywords internal

permutation_test <- function(D, group_sizes, perm_indices, observed_stat, density.weights) {
  n <- ncol(perm_indices)
  N <- nrow(perm_indices)
  perm_stats <- numeric(N)

  for (i in 1:N) {
    D_perm <- D[perm_indices[i, ], perm_indices[i, ]]
    perm_stats[i] <- compute_b_w_ratio(D_perm, group_sizes, weights = density.weights)
  }

  return(mean(perm_stats >= observed_stat))
}
