% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dep_quantiles.R
\name{dep_quantiles}
\alias{dep_quantiles}
\title{Return Quantiles of a Variable}
\usage{
dep_quantiles(.data, source_var, new_var, n = 4L, return = "label")
}
\arguments{
\item{.data}{A tibble containing the data to be used for calculating quantiles.}

\item{source_var}{Required; the quoted or unquoted source variable to be
divided into quantiles.}

\item{new_var}{Required; the quoted or unquoted name of the new variable to
be created containing the quantile values.}

\item{n}{Required integer scalar; the number of quantiles to divide the source
variable into. Defaults to \code{4L} (quartiles), but can be set to any
value appropriate for your data as long as it is greater than or equal
to \code{2L}.}

\item{return}{Required character scalar; one of either \code{"label"} (default)
or \code{"factor"}. If \code{"label"}, the function will return a character
vector of quantile labels. If \code{"factor"}, the function will return
the underlying factor used in the creation of the quantiles measure.}
}
\value{
A copy of \code{.data} with a new variable containing the requested
    quantile.
}
\description{
This helper function can be used to return quantiles of a
    deprivation index (or any other continuous distribution). This is useful
    for constructing independent variables for statistical analysis. The
    function supports splitting a distribution at the median (2 quantiles)
    through deciles (10 quantiles) if character labels are desired.
}
\examples{
## load sample data
ndi_m <- dep_sample_data(index = "ndi_m")

## calculate NDI with sample data
ndi_m <- dep_calc_index(ndi_m, geography = "county", index = "ndi_m", year = 2022,
    return_percentiles = TRUE)

## calculate quantiles, return label
ndi_m <- dep_quantiles(ndi_m, source_var = NDI_M, new_var = ndi_m_quartiles_l)

unique(sort(ndi_m$ndi_m_quartiles_l))

## calculate quantiles, return label
ndi_m <- dep_quantiles(ndi_m, source_var = NDI_M, new_var = ndi_m_quartiles_l6,
                       n = 6L)

unique(sort(ndi_m$ndi_m_quartiles_l6))

## calculate quantiles, return factor
ndi_m <- dep_quantiles(ndi_m, source_var = NDI_M, new_var = ndi_m_quartiles_f,
    return = "factor")

levels(ndi_m$ndi_m_quartiles_f)

}
