% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_dist_plot.R
\name{norm_dist_plot}
\alias{norm_dist_plot}
\title{Create density histogram with normal distribution overlaid}
\usage{
norm_dist_plot(df, vars)
}
\arguments{
\item{df}{A data.frame or tibble.}

\item{vars}{A character vector of continuous variable names.}
}
\value{
A \code{ggplot} object.
}
\description{
Plots a simple density histogram for a continuous variable with a normal
distribution overlaid. The overlaid normal distribution has the same mean
and standard deviation as the provided variable, and the plot provides a
visual means to assess the normality of the variable's distribution.
}
\examples{
norm_dist_plot(df = iris, vars = "Sepal.Width")

norm_dist_plot(df = iris,
               vars = c("Sepal.Width", "Sepal.Length"))
}
