% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gets.R
\name{zeit_get}
\alias{zeit_get}
\title{Get detailled content from the ZEIT archive}
\source{
\url{http://developer.zeit.de/docs/}
}
\usage{
zeit_get(endpoint, id, fields, print = TRUE)
}
\arguments{
\item{endpoint}{one of \code{author}, \code{content}, \code{department}, \code{keyword},
\code{product} or \code{series} -- see \code{\link{zeit_search}}.}

\item{id}{item id.}

\item{fields}{partially select output fields, as string value or vector of strings for multiple fields.}

\item{print}{if \code{TRUE} (default) the meta data are printed.}
}
\value{
List of metadata items.
}
\description{
\code{zeit_get} will get you all available metadata for a specific item.
}
\details{
\emph{Endpoints}

The API is structured into several endpoints that provide specific functionalities:
\tabular{lll}{
\tab \code{author} \tab content by this author \cr
\tab \code{content} \tab get content by ID \cr
\tab \code{department} \tab content from this department \cr
\tab \code{keyword} \tab content about this keyword \cr
\tab \code{product} \tab content from this product \cr
\tab \code{series} \tab content in this series
}
}
\examples{
\dontrun{
# get article metadata by ID
zeit_get("content", "3Ed7KYJOO2MXu5SQtnudQA")

# partial selection of output fields
zeit_get("content", "3Ed7KYJOO2MXu5SQtnudQA",
  fields=c("title", "release_date", "href"))

# hide result
article.meta <- zeit_get("content", "3Ed7KYJOO2MXu5SQtnudQA", print=FALSE)
}
}

